/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.DefaultExecutor;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
public class ExecutionContextTest {
    @Test
    public void testExecutionContext() throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionContext orig = ExecutionContexts.current();
        try (ExecutionContext ec = ExecutionContexts.start((long)10L, (TimeUnit)TimeUnit.SECONDS);){
            long unitsToDeadline = ExecutionContexts.current().getTimeToDeadline(TimeUnit.SECONDS);
            Assert.assertThat((Object)unitsToDeadline, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(10L)));
            Assert.assertThat((Object)unitsToDeadline, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(9L)));
            Future<?> submit = DefaultExecutor.INSTANCE.submit(() -> {
                try (ExecutionContext subCtx = ExecutionContexts.start((ExecutionContext)ec);){
                    long utd = ExecutionContexts.current().getUncheckedTimeToDeadline(TimeUnit.SECONDS);
                    Assert.assertThat((Object)utd, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(10L)));
                    Assert.assertThat((Object)utd, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(9L)));
                    Assert.assertEquals((Object)ec, (Object)subCtx.getParent());
                }
                Assert.assertNull((Object)ExecutionContexts.current());
            });
            submit.get();
        }
        Assert.assertSame((Object)orig, (Object)ExecutionContexts.current());
    }

    @Test
    public void testExecutionContext2() throws TimeoutException {
        try (ExecutionContext start = ExecutionContexts.start((long)10L, (TimeUnit)TimeUnit.SECONDS);){
            long secs = start.getTimeToDeadline(TimeUnit.SECONDS);
            Assert.assertTrue((secs >= 9L ? 1 : 0) != 0);
            Assert.assertTrue((secs <= 10L ? 1 : 0) != 0);
            start.put((Object)"KEY", (Object)"BAGAGE");
            Assert.assertEquals((Object)"BAGAGE", (Object)start.get((Object)"KEY", String.class));
        }
    }

    @Test
    public void testExecutionContext3() {
        try (ExecutionContext start = ExecutionContexts.start((long)10L, (TimeUnit)TimeUnit.SECONDS);){
            long secs = (Runtime.getDeadline() - System.currentTimeMillis()) / 1000L;
            Assert.assertTrue((String)("secs = " + secs), (secs >= 9L ? 1 : 0) != 0);
            Assert.assertTrue((String)("secs = " + secs), (secs <= 10L ? 1 : 0) != 0);
            start.put((Object)"KEY", (Object)"BAGAGE");
            Assert.assertEquals((Object)"BAGAGE", (Object)start.get((Object)"KEY", String.class));
        }
    }
}

