/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.base.Pair;
import org.spf4j.base.Reflections;

public final class ReflectionsTest {
    private static final Class<?>[] PARAMS = new Class[]{String.class, Integer.class};

    @Test
    public void testReflections() {
        Method reflect = Reflections.getCompatibleMethod(String.class, (String)"indexOf", (Class[])PARAMS);
        Method fastM = Reflections.getCompatibleMethodCached(String.class, (String)"indexOf", (Class[])PARAMS);
        Assert.assertEquals((Object)reflect, (Object)fastM);
        Method method = Reflections.getMethod(String.class, (String)"indexOf", (Class[])new Class[]{Integer.TYPE});
        Assert.assertEquals((Object)"indexOf", (Object)method.getName());
        method = Reflections.getMethod(String.class, (String)"bla", (Class[])new Class[]{Character.TYPE});
        Assert.assertNull((Object)method);
        Constructor cons = Reflections.getConstructor(String.class, (Class[])new Class[]{byte[].class});
        Assert.assertNotNull((Object)cons);
        cons = Reflections.getConstructor(String.class, (Class[])new Class[]{Pair.class});
        Assert.assertNull((Object)cons);
    }

    public static String print(Object ... args) {
        return Arrays.toString(args);
    }

    public static void caca() {
    }

    @Test
    public void testImplement() {
        Printing prt = (Printing)Reflections.implementStatic(Printing.class, ReflectionsTest.class);
        String result = prt.print("a", 3);
        Assert.assertEquals((Object)"[a, 3]", (Object)result);
    }

    public static interface Printing {
        public String print(Object ... var1);

        public void caca();
    }
}

