/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import com.google.common.base.Charsets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.sql.Date;
import java.time.Instant;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.DateTimeFormats;
import org.spf4j.base.EscapeJsonStringAppendableWrapper;
import org.spf4j.base.Pair;
import org.spf4j.base.Slf4jMessageFormatter;
import org.spf4j.io.AppendableLimiterWithOverflow;
import org.spf4j.io.ConfigurableAppenderSupplier;
import org.spf4j.io.ObjectAppender;
import org.spf4j.io.ObjectAppenderSupplier;
import org.spf4j.ssdump2.avro.AMethod;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public class Slf4jMessageFormatterTest {
    private static final Logger LOG = LoggerFactory.getLogger(Slf4jMessageFormatterTest.class);

    @Test
    public void testFormatter() throws IOException {
        StringBuilder sb = new StringBuilder();
        Slf4jMessageFormatter.format((Appendable)sb, (String)"bla bla", (Object[])new Object[0]);
        Assert.assertEquals((Object)"bla bla", (Object)sb.toString());
        sb.setLength(0);
        Slf4jMessageFormatter.format((Appendable)sb, (String)"bla bla {}", (Object[])new Object[]{"coco"});
        Assert.assertEquals((Object)"bla bla coco", (Object)sb.toString());
        sb.setLength(0);
        Slf4jMessageFormatter.format((Appendable)sb, (String)"\\{}bla bla {}", (Object[])new Object[]{"coco"});
        Assert.assertEquals((Object)"{}bla bla coco", (Object)sb.toString());
        sb.setLength(0);
        int processed = Slf4jMessageFormatter.format((Appendable)sb, (String)"Some Message", (Object[])new Object[]{"coco"});
        Assert.assertEquals((Object)"Some Message", (Object)sb.toString());
        Assert.assertEquals((long)0L, (long)processed);
        sb.setLength(0);
        processed = Slf4jMessageFormatter.format((Appendable)sb, (String)"Some Message {}", (ObjectAppenderSupplier)new ConfigurableAppenderSupplier(), (Object[])new Object[]{Pair.of((Object)"a", (Object)"b")});
        Assert.assertEquals((Object)"Some Message a,b", (Object)sb.toString());
        Assert.assertEquals((long)1L, (long)processed);
    }

    @Test
    public void testFormatter2() throws IOException {
        ConfigurableAppenderSupplier appSupp = new ConfigurableAppenderSupplier();
        LOG.debug("ConfAppenderSupp = {}", (Object)appSupp);
        StringBuilder sb = new StringBuilder();
        long currentTimeMillis = System.currentTimeMillis();
        Slf4jMessageFormatter.format((Appendable)sb, (String)"bla bla {}", (ObjectAppenderSupplier)appSupp, (Object[])new Object[]{new Date(currentTimeMillis)});
        Assert.assertEquals((Object)("bla bla " + DateTimeFormats.DT_FORMAT.format(Instant.now())), (Object)sb.toString());
        sb.setLength(0);
        AMethod method = AMethod.newBuilder().setName("m1").setDeclaringClass("c1").build();
        int written = Slf4jMessageFormatter.format((Appendable)sb, (String)"bla bla {}", (ObjectAppenderSupplier)appSupp, (Object[])new Object[]{method});
        Assert.assertEquals((Object)"bla bla {\"declaringClass\":\"c1\",\"name\":\"m1\"}", (Object)sb.toString());
        Assert.assertEquals((long)1L, (long)written);
        sb.setLength(0);
        written = Slf4jMessageFormatter.format((int)1, (Appendable)sb, (String)"bla bla {}", (ObjectAppenderSupplier)appSupp, (Object[])new Object[]{"ifff", method});
        Assert.assertEquals((Object)"bla bla {\"declaringClass\":\"c1\",\"name\":\"m1\"}", (Object)sb.toString());
        Assert.assertEquals((long)2L, (long)written);
        sb.setLength(0);
        written = Slf4jMessageFormatter.format((Appendable)sb, (String)"bla bla {}", (ObjectAppenderSupplier)appSupp, (Object[])new Object[]{method, "yohooo"});
        LOG.debug("formatted message: {}", (Object)sb);
        Assert.assertEquals((long)1L, (long)written);
        sb.setLength(0);
        written = Slf4jMessageFormatter.format((Appendable)sb, (String)"bla bla {}", (ObjectAppenderSupplier)appSupp, (Object[])new Object[0]);
        LOG.debug("formatted message: {}", (Object)sb);
        Assert.assertEquals((long)0L, (long)written);
        sb.setLength(0);
        EscapeJsonStringAppendableWrapper escaper = new EscapeJsonStringAppendableWrapper((Appendable)sb);
        Slf4jMessageFormatter.format((Appendable)escaper, (String)"bla bla {} {}", (ObjectAppenderSupplier)appSupp, (Object[])new Object[]{"\n\u2013\u0010", new int[]{1, 2, 3}});
        LOG.debug("formatted message: {}", (Object)sb);
        Assert.assertEquals((Object)"bla bla \\n\u2013\\u0010 [1, 2, 3]", (Object)sb.toString());
        appSupp.replace(String.class, input -> new ObjectAppender<String>(){

            public void append(String object, Appendable appendTo) throws IOException {
                try (AppendableLimiterWithOverflow limiter = new AppendableLimiterWithOverflow(90, File.createTempFile("string", ".overflow"), (CharSequence)"...@", Charsets.UTF_8, appendTo);){
                    limiter.append((CharSequence)object);
                }
            }
        });
        sb.setLength(0);
        Slf4jMessageFormatter.format((Appendable)sb, (String)"bla bla {}", (ObjectAppenderSupplier)appSupp, (Object[])new Object[]{"01234567890123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789"});
        LOG.debug("formatted message: {}", (Object)sb);
        Assert.assertThat((Object)sb.toString(), (Matcher)Matchers.containsString((String)"...@"));
    }
}

