/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.stream.Collector;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.base.XCollectors;

public class XCollectorsTest {
    @Test
    public void testLimit() {
        ArrayDeque collect = (ArrayDeque)Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 0).stream().collect(XCollectors.last((int)5));
        Assert.assertThat((Object)collect, (Matcher)Matchers.contains((Object[])new Integer[]{6, 7, 8, 9, 0}));
        Assert.assertEquals((long)5L, (long)collect.size());
    }

    @Test
    public void testLimit2() {
        ArrayDeque collect = (ArrayDeque)Arrays.asList(1, 2, 3, 4, 5).stream().collect(XCollectors.last((int)10));
        Assert.assertThat((Object)collect, (Matcher)Matchers.contains((Object[])new Integer[]{1, 2, 3, 4, 5}));
        Assert.assertEquals((long)5L, (long)collect.size());
    }

    @Test
    public void testLimit3() {
        ArrayDeque collect = (ArrayDeque)Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 0).stream().collect(XCollectors.last((int)5, (Object)-1));
        Assert.assertThat((Object)collect, (Matcher)Matchers.contains((Object[])new Integer[]{-1, 7, 8, 9, 0}));
        Assert.assertEquals((long)5L, (long)collect.size());
    }

    @Test
    public void testLimit4() {
        ArrayDeque collect = (ArrayDeque)Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 0).stream().collect(XCollectors.last((int)10, (Object)-1));
        Assert.assertThat((Object)collect, (Matcher)Matchers.contains((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 0}));
        Assert.assertEquals((long)10L, (long)collect.size());
    }

    @Test
    public void testFiltering() {
        ArrayDeque collect = (ArrayDeque)Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 0).stream().collect(XCollectors.filtering(n -> n <= 5, (Collector)XCollectors.last((int)3, (Object)-1)));
        Assert.assertThat((Object)collect, (Matcher)Matchers.contains((Object[])new Integer[]{-1, 5, 0}));
        Assert.assertEquals((long)3L, (long)collect.size());
    }
}

