/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.util.EnumSet;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.FileBasedLock;

@SuppressFBWarnings(value={"MDM_THREAD_YIELD", "PATH_TRAVERSAL_IN"})
public final class FileBasedLockTest {
    private static final Logger LOG = LoggerFactory.getLogger(FileBasedLockTest.class);
    private static final String LOCK_FILE = Runtime.TMP_FOLDER + File.separatorChar + "test.lock";
    private volatile boolean isOtherRunning;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=60000L)
    public void test() throws IOException, InterruptedException, ExecutionException {
        FileBasedLock lock = FileBasedLock.getLock((File)new File(LOCK_FILE));
        lock.lock();
        Future<Void> future = DefaultExecutor.INSTANCE.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                Runtime.jrun(FileBasedLockTest.class, (long)60000L, (String[])new String[]{LOCK_FILE});
                FileBasedLockTest.this.isOtherRunning = false;
                return null;
            }
        });
        try {
            this.isOtherRunning = true;
            for (int i = 1; i < 10000; ++i) {
                if (!this.isOtherRunning) {
                    future.get();
                    Assert.fail((String)"The Other process should be running, lock is not working");
                }
                Thread.sleep(1L);
            }
        }
        finally {
            lock.unlock();
        }
        LOG.debug("Lock test successful");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SuppressFBWarnings(value={"AFBR_ABNORMAL_FINALLY_BLOCK_RETURN"})
    public void testReentrace() throws IOException {
        File tmp = File.createTempFile("bla", ".lock");
        try (FileBasedLock lock = FileBasedLock.getLock((File)tmp);){
            lock.lock();
            try {
                lock.lock();
                try {
                    LOG.debug("Reentered lock");
                }
                finally {
                    lock.unlock();
                }
                boolean tryLock = lock.tryLock();
                Assert.assertTrue((boolean)tryLock);
                lock.unlock();
            }
            finally {
                lock.unlock();
            }
        }
        finally {
            if (!tmp.delete()) {
                throw new IOException("Cannot delete " + tmp);
            }
        }
    }

    public static void main(String[] args) throws InterruptedException, IOException {
        FileBasedLock lock = FileBasedLock.getLock((File)new File(args[0]));
        lock.lock();
        try {
            Thread.sleep(100L);
        }
        finally {
            lock.unlock();
        }
        System.exit(0);
    }

    @Test(expected=OverlappingFileLockException.class)
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testFileLock() throws IOException {
        File tmp = File.createTempFile("test", ".lock");
        tmp.deleteOnExit();
        RandomAccessFile file = new RandomAccessFile(tmp, "rws");
        FileChannel channel = file.getChannel();
        FileLock lock = channel.lock();
        FileLock lock1 = channel.lock();
        Assert.fail();
        lock1.release();
        lock.release();
    }

    @Test
    public void testFileLock2() throws IOException, InterruptedException {
        File tmp = File.createTempFile("test", ".lock");
        tmp.deleteOnExit();
        FileBasedLock lock = FileBasedLock.getLock((File)tmp);
        Assert.assertTrue((boolean)lock.tryLock());
        FileBasedLock lock2 = FileBasedLock.getLock((File)tmp);
        Assert.assertTrue((boolean)lock2.tryLock(1L, TimeUnit.SECONDS));
        lock2.unlock();
        lock.unlock();
    }

    @Test
    @SuppressFBWarnings(value={"UAC_UNNECESSARY_API_CONVERSION_FILE_TO_PATH"})
    public void testFileLockPermissions() throws IOException {
        File tmpDir = com.google.common.io.Files.createTempDir();
        EnumSet<PosixFilePermission> reqPermissions = EnumSet.of(PosixFilePermission.GROUP_READ, PosixFilePermission.GROUP_WRITE, PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE);
        FileAttribute<Set<PosixFilePermission>> attr = PosixFilePermissions.asFileAttribute(reqPermissions);
        File file = new File(tmpDir, "file.lock");
        FileBasedLock lock = FileBasedLock.getLock((File)file, (FileAttribute[])new FileAttribute[]{attr});
        Assert.assertTrue((boolean)lock.tryLock());
        lock.unlock();
        Set<PosixFilePermission> actualPermissions = Files.getPosixFilePermissions(file.toPath(), new LinkOption[0]);
        Assert.assertEquals(reqPermissions, actualPermissions);
    }
}

