/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Threads;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.LifoThreadPoolExecutorSQP;

@SuppressFBWarnings(value={"HES_LOCAL_EXECUTOR_SERVICE", "PREDICTABLE_RANDOM"})
public class LifoThreadPoolExecutor2Test {
    private static final Logger LOG = LoggerFactory.getLogger(LifoThreadPoolExecutor2Test.class);
    private static final Runnable NOP = new Runnable(){

        @Override
        public void run() {
        }
    };

    @Test
    public void testLifoExecSQ() throws InterruptedException, IOException, ExecutionException {
        LifoThreadPoolExecutorSQP executor = new LifoThreadPoolExecutorSQP("test", 2, 8, 1000, 0);
        LifoThreadPoolExecutor2Test.testPoolThreadDynamics((ExecutorService)executor);
    }

    @Test
    @Ignore
    public void testJdkExec() throws InterruptedException, IOException, ExecutionException {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(1024);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(4, 8, 1000L, TimeUnit.MILLISECONDS, linkedBlockingQueue);
        LifoThreadPoolExecutor2Test.testPoolThreadDynamics(executor);
    }

    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "ITC_INHERITANCE_TYPE_CHECKING"})
    public static void testPoolThreadDynamics(ExecutorService executor) throws InterruptedException, IOException, ExecutionException {
        LifoThreadPoolExecutor2Test.testMaxParallel(executor, 4, 4L, TimeUnit.SECONDS);
        if (executor instanceof LifoThreadPoolExecutorSQP) {
            LifoThreadPoolExecutorSQP le = (LifoThreadPoolExecutorSQP)executor;
            Assert.assertEquals((long)4L, (long)le.getThreadCount());
            LifoThreadPoolExecutor2Test.testMaxParallel(executor, 2, 4L, TimeUnit.SECONDS);
            Assert.assertEquals((long)2L, (long)le.getThreadCount());
        } else if (executor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor tpe = (ThreadPoolExecutor)executor;
            Assert.assertEquals((long)4L, (long)tpe.getPoolSize());
            try {
                while (true) {
                    executor.execute(NOP);
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                Assert.assertEquals((long)8L, (long)tpe.getPoolSize());
                LifoThreadPoolExecutor2Test.testMaxParallel(executor, 2, 4L, TimeUnit.SECONDS);
                Assert.assertEquals((long)8L, (long)tpe.getPoolSize());
            }
        } else {
            throw new IllegalStateException("Unsupported " + executor);
        }
        executor.shutdown();
        boolean awaitTermination = executor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)awaitTermination);
    }

    public static void testMaxParallel(ExecutorService executor, int maxParallel, long time, TimeUnit unit) throws InterruptedException {
        long currTime;
        final LongAdder adder = new LongAdder();
        final LongAdder exNr = new LongAdder();
        int nrExCaught = 0;
        long rejected = 0L;
        Runnable runnable = new Runnable(){

            @Override
            @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
            public void run() {
                adder.increment();
                long sleep = ThreadLocalRandom.current().nextLong(0L, 100L);
                if (sleep < 10L) {
                    exNr.increment();
                    throw new IllegalStateException();
                }
                try {
                    Thread.sleep(sleep);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        ArrayList futures = new ArrayList(maxParallel);
        long start = currTime = TimeSource.nanoTime();
        long deadlineNanos = currTime + unit.toNanos(time);
        int i = 0;
        while (deadlineNanos - currTime > 0L) {
            if (i > 0 && i % maxParallel == 0) {
                nrExCaught += LifoThreadPoolExecutor2Test.consume(futures);
            }
            futures.add(executor.submit(runnable));
            currTime = TimeSource.nanoTime();
            ++i;
        }
        LOG.debug("Stats for {}, maxParallel = {}, rejected = {}, Exec time = {} ns", new Object[]{executor.getClass(), maxParallel, rejected, currTime - start});
        LOG.debug("Threads: {}", (Object[])Threads.getThreads());
        Assert.assertEquals((long)i, (long)adder.sum());
        Assert.assertEquals((long)(nrExCaught += LifoThreadPoolExecutor2Test.consume(futures)), (long)exNr.sum());
    }

    public static int consume(List<Future<?>> futures) throws InterruptedException {
        int nrEx = 0;
        for (Future<?> fut : futures) {
            try {
                fut.get();
            }
            catch (ExecutionException ex) {
                ++nrEx;
            }
        }
        futures.clear();
        return nrEx;
    }
}

