/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.LifoThreadPoolExecutorSQP;
import org.spf4j.concurrent.MutableLifoThreadPoolExecutorSQP;
import org.spf4j.perf.cpu.CpuUsageSampler;
import org.spf4j.stackmonitor.Sampler;

@SuppressFBWarnings(value={"MDM_THREAD_YIELD", "PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
public class LifoThreadPoolExecutorCoreIdlingTest {
    private static final Logger LOG = LoggerFactory.getLogger(LifoThreadPoolExecutorCoreIdlingTest.class);

    @Test(timeout=60000L)
    public void testLifoExecSQ() throws InterruptedException, IOException {
        LifoThreadPoolExecutorSQP executor = new LifoThreadPoolExecutorSQP("test", 2, 8, 20, 0);
        Sampler s = Sampler.getSampler((int)20, (int)10000, (File)new File(Runtime.TMP_FOLDER), (String)"lifeTest1");
        s.start();
        Runtime.gc((long)5000L);
        Thread.sleep(100L);
        long time = CpuUsageSampler.getProcessCpuTimeNanos();
        Thread.sleep(3000L);
        long cpuTime = CpuUsageSampler.getProcessCpuTimeNanos() - time;
        LOG.info("Cpu profile saved to {}", (Object)s.dumpToFile());
        LOG.debug("CPU time = {} ns", (Object)cpuTime);
        s.stop();
        Assert.assertTrue((String)("CPU Time = " + cpuTime), (cpuTime < 1500000000L ? 1 : 0) != 0);
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.SECONDS);
    }

    @Test
    public void testLifoExecSQMutable() throws InterruptedException, IOException {
        MutableLifoThreadPoolExecutorSQP executor = new MutableLifoThreadPoolExecutorSQP("test", 2, 8, 20, 1024, 0);
        Sampler s = Sampler.getSampler((int)20, (int)10000, (File)new File(Runtime.TMP_FOLDER), (String)"lifeTest1");
        s.start();
        Runtime.gc((long)5000L);
        Thread.sleep(100L);
        long time = CpuUsageSampler.getProcessCpuTimeNanos();
        Thread.sleep(3000L);
        long cpuTime = CpuUsageSampler.getProcessCpuTimeNanos() - time;
        LOG.info("Cpu profile saved to {}", (Object)s.dumpToFile());
        LOG.debug("CPU time = {} ns", (Object)cpuTime);
        s.stop();
        Assert.assertTrue((String)("CPU Time = " + cpuTime), (cpuTime < 1500000000L ? 1 : 0) != 0);
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.SECONDS);
    }
}

