/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Throwables;
import org.spf4j.concurrent.LifoThreadPool;
import org.spf4j.concurrent.LifoThreadPoolBuilder;
import org.spf4j.concurrent.LifoThreadPoolExecutorSQP;
import org.spf4j.concurrent.MutableLifoThreadPool;
import org.spf4j.concurrent.RejectedExecutionHandler;
import org.spf4j.test.log.AsyncObservationAssert;
import org.spf4j.test.log.TestLoggers;

@SuppressFBWarnings(value={"HES_LOCAL_EXECUTOR_SERVICE", "MDM_THREAD_YIELD"})
public class LifoThreadPoolExecutorTest {
    private static final Logger LOG = LoggerFactory.getLogger(LifoThreadPoolExecutorTest.class);

    @Test
    public void testLifoExecSQ() throws InterruptedException, IOException {
        LifoThreadPoolExecutorSQP executor = new LifoThreadPoolExecutorSQP("test", 8, 8, 60000, 1024);
        LifoThreadPoolExecutorTest.testPool((ExecutorService)executor);
    }

    @Test
    public void testLifoExecSQZeroQueue() throws InterruptedException, IOException {
        RejectedExecutionExceptionImpl ex = new RejectedExecutionExceptionImpl();
        LifoThreadPool executor = LifoThreadPoolBuilder.newBuilder().withCoreSize(0).withMaxSize(16).withMaxIdleTimeMillis(60000).withQueueSizeLimit(0).withRejectionHandler((a, b) -> {
            throw ex;
        }).build();
        LifoThreadPoolExecutorTest.testPool((ExecutorService)executor);
    }

    @Test(timeout=60000L)
    public void testMutableLifoExecSQZeroQueue() throws InterruptedException, IOException {
        RejectedExecutionExceptionImpl ex = new RejectedExecutionExceptionImpl();
        MutableLifoThreadPool executor = LifoThreadPoolBuilder.newBuilder().withCoreSize(0).withMaxSize(16).withMaxIdleTimeMillis(60000).withQueueSizeLimit(0).withRejectionHandler((a, b) -> {
            throw ex;
        }).withSpinLockCount(1024).buildMutable();
        LifoThreadPoolExecutorTest.testPool((ExecutorService)executor);
    }

    @Test(expected=RejectedExecutionException.class)
    public void testRejectZeroQueueSizeTp() {
        LifoThreadPool executor = LifoThreadPoolBuilder.newBuilder().withCoreSize(0).withMaxSize(1).withQueueSizeLimit(0).build();
        try {
            executor.execute(() -> {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                }
            });
            executor.execute(() -> {});
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testRejectHandlerZeroQueueSizeTp() {
        LifoThreadPool executor = LifoThreadPoolBuilder.newBuilder().withCoreSize(0).withMaxSize(1).withQueueSizeLimit(0).withRejectionHandler(RejectedExecutionHandler.RUN_IN_CALLER_EXEC_HANDLER).build();
        AtomicReference ref = new AtomicReference();
        try {
            executor.execute(() -> {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {
                    Thread.interrupted();
                }
            });
            executor.execute(() -> ref.set(Thread.currentThread()));
            Assert.assertEquals((Object)Thread.currentThread(), ref.get());
        }
        finally {
            executor.shutdownNow();
        }
    }

    @Test
    public void testLifoExecSQShutdownNow() throws InterruptedException, IOException {
        LifoThreadPool executor = LifoThreadPoolBuilder.newBuilder().withCoreSize(2).withMaxSize(8).withQueueSizeLimit(1024).build();
        executor.execute(() -> {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException ex) {
                Throwables.writeTo((Throwable)ex, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
            }
        });
        executor.execute(() -> {
            try {
                Thread.sleep(Long.MAX_VALUE);
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
            }
        });
        executor.shutdown();
        Assert.assertFalse((boolean)executor.awaitTermination(10L, TimeUnit.MILLISECONDS));
        executor.shutdownNow();
        Assert.assertTrue((boolean)executor.awaitTermination(1000L, TimeUnit.MILLISECONDS));
    }

    @Test
    @Ignore
    public void testJdkExec() throws InterruptedException, IOException {
        LinkedBlockingQueue<Runnable> linkedBlockingQueue = new LinkedBlockingQueue<Runnable>(1024);
        ThreadPoolExecutor executor = new ThreadPoolExecutor(8, 8, 60000L, TimeUnit.MILLISECONDS, linkedBlockingQueue);
        LifoThreadPoolExecutorTest.testPool(executor);
    }

    @Test
    @Ignore
    public void testJdkFJPExec() throws InterruptedException, IOException {
        ForkJoinPool executor = new ForkJoinPool(8);
        LifoThreadPoolExecutorTest.testPool(executor);
    }

    public static void testPool(ExecutorService executor) throws InterruptedException, IOException {
        final LongAdder adder = new LongAdder();
        int testCount = 10000000;
        long rejected = 0L;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                adder.increment();
            }
        };
        long start = System.currentTimeMillis();
        AsyncObservationAssert obs = TestLoggers.sys().expectUncaughtException(Matchers.hasProperty((String)"throwable", (Matcher)Matchers.any(IllegalStateException.class)));
        executor.execute(new Runnable(){

            @Override
            public void run() {
                throw new IllegalStateException();
            }
        });
        obs.assertObservation(10L, TimeUnit.SECONDS);
        for (int i = 0; i < 10000000; ++i) {
            try {
                executor.execute(runnable);
                continue;
            }
            catch (RejectedExecutionException ex) {
                ++rejected;
                runnable.run();
            }
        }
        executor.shutdown();
        boolean awaitTermination = executor.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        LOG.debug("Stats for {}, submited = {}, rejected = {}, Exec time = {}", new Object[]{executor.getClass(), 10000000, rejected, System.currentTimeMillis() - start});
        Assert.assertTrue((boolean)awaitTermination);
        Assert.assertEquals((long)10000000L, (long)adder.sum());
    }

    private static final class RejectedExecutionExceptionImpl
    extends RejectedExecutionException {
        RejectedExecutionExceptionImpl() {
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

