/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.spf4j.failsafe.Request;
import org.spf4j.failsafe.Response;

public final class Server {
    private final Map<String, Function<Request, Response>> responses = new HashMap<String, Function<Request, Response>>();
    private volatile Exception breakException;

    public void breakException(Exception ex) {
        this.breakException = ex;
    }

    public void setResponse(String url, Function<Request, Response> response) {
        this.responses.put(url, response);
    }

    public Response execute(Request request) throws Exception {
        if (this.breakException != null) {
            throw this.breakException;
        }
        long deadlineMSEpoch = request.getDeadlineMSEpoch();
        long timeout = deadlineMSEpoch - System.currentTimeMillis();
        if (timeout < 0L) {
            return new Response(Response.Type.TRANSIENT_ERROR, timeout);
        }
        Response resp = this.responses.get(request.getUrl()).apply(request);
        if (resp == null) {
            return new Response(Response.Type.CLIENT_ERROR, null);
        }
        return resp;
    }

    public String toString() {
        return "Server{responses=" + this.responses + ", breakException=" + this.breakException + '}';
    }
}

