/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import com.google.common.base.Charsets;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.io.AppendableLimiterWithOverflow;

public class AppendableLimiterWithFileOverflowTest {
    private static final Logger LOG = LoggerFactory.getLogger(AppendableLimiterWithFileOverflowTest.class);

    @Test
    public void testOverflow() throws IOException {
        File ovflow = File.createTempFile("overflow", ".txt");
        StringBuilder destination = new StringBuilder();
        String testStr = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
        try (AppendableLimiterWithOverflow limiter = new AppendableLimiterWithOverflow(90, ovflow, (CharSequence)"...@", Charsets.UTF_8, (Appendable)destination);){
            limiter.append("0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".subSequence(0, 45));
            limiter.append("0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".charAt(45));
            limiter.append("0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".subSequence(46, "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".length()));
        }
        LOG.debug("Destination str {}", (Object)destination);
        Assert.assertEquals((long)90L, (long)destination.length());
        String oContent = CharStreams.toString((Readable)new InputStreamReader(Files.newInputStream(ovflow.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789", (Object)oContent);
    }

    @Test
    public void testOverflowX() throws IOException {
        File ovflow = File.createTempFile("overflow", ".txt");
        StringBuilder destination = new StringBuilder();
        String testStr = "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
        int nr = ovflow.getPath().length() + 4;
        try (AppendableLimiterWithOverflow limiter = new AppendableLimiterWithOverflow(90, ovflow, (CharSequence)"...@", Charsets.UTF_8, (Appendable)destination);){
            limiter.append("0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".subSequence(0, nr));
            limiter.append("0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".charAt(nr));
            limiter.append("0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".subSequence(nr + 1, "0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".length()));
        }
        LOG.debug("Destination: {}", (Object)destination);
        Assert.assertEquals((long)90L, (long)destination.length());
        String oContent = CharStreams.toString((Readable)new InputStreamReader(Files.newInputStream(ovflow.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"0123456789012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789", (Object)oContent);
    }

    @Test
    public void testOverflow2() throws IOException {
        File ovflow = File.createTempFile("overflow", ".txt");
        StringBuilder destination = new StringBuilder();
        String testStr = "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789";
        try (AppendableLimiterWithOverflow limiter = new AppendableLimiterWithOverflow(90, ovflow, (CharSequence)"...@", Charsets.UTF_8, (Appendable)destination);){
            limiter.append("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".subSequence(0, 45));
            limiter.append("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".charAt(45));
            limiter.append("012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".subSequence(46, "012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789".length()));
        }
        LOG.debug("Destination: {}", (Object)destination);
        Assert.assertEquals((long)90L, (long)destination.length());
        Assert.assertEquals((Object)"012345678901234567890123456789012345678901234567890123456789012345678901234567890123456789", (Object)destination.toString());
        String oContent = CharStreams.toString((Readable)new InputStreamReader(Files.newInputStream(ovflow.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
        Assert.assertEquals((Object)"", (Object)oContent);
    }
}

