/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.IntMath;
import org.spf4j.base.Strings;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.io.MemorizingBufferedInputStream;
import org.spf4j.io.PipedOutputStream;

public class PipedOutputStreamTest {
    @Test
    public void testStreamPiping() throws IOException {
        PipedOutputStreamTest.test("This is a super cool, mega dupper test string for testing piping..........E", 8, false);
        IntMath.XorShift32 random = new IntMath.XorShift32();
        for (int i = 0; i < 100; ++i) {
            int nrChars = Math.abs(random.nextInt() % 100000);
            StringBuilder sb = PipedOutputStreamTest.generateTestStr(nrChars);
            PipedOutputStreamTest.test(sb.toString(), Math.abs(random.nextInt() % 10000) + 2, false);
        }
        PipedOutputStreamTest.test(PipedOutputStreamTest.generateTestStr(133).toString(), 2, false);
    }

    public static StringBuilder generateTestStr(int nrChars) {
        IntMath.XorShift32 random = new IntMath.XorShift32();
        StringBuilder sb = new StringBuilder(nrChars);
        for (int i = 0; i < nrChars; ++i) {
            sb.append((char)Math.abs(random.nextInt() % 100) + 20);
        }
        return sb;
    }

    public static void test(final String testStr, int buffSize, boolean buffered) throws IOException {
        final PipedOutputStream pos = new PipedOutputStream(buffSize);
        InputStream pis = buffered ? new MemorizingBufferedInputStream(pos.getInputStream()) : pos.getInputStream();
        DefaultExecutor.INSTANCE.execute((Runnable)new AbstractRunnable(){

            public void doRun() throws Exception {
                try (PipedOutputStream os = pos;){
                    byte[] utf8 = Strings.toUtf8((String)testStr);
                    os.write(utf8[0]);
                    os.write(utf8, 1, 10);
                    os.write(utf8, 11, utf8.length - 11);
                }
            }
        });
        StringBuilder sb = new StringBuilder();
        try (InputStream is = pis;){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = is.read(buffer)) > 0) {
                sb.append(Strings.fromUtf8((byte[])buffer, (int)0, (int)read));
            }
        }
        Assert.assertEquals((Object)testStr, (Object)sb.toString());
    }

    @Test(expected=IOException.class)
    public void testNoReaderBehaviour() throws IOException {
        PipedOutputStream os = new PipedOutputStream(1024);
        try (PipedOutputStream pos = os;){
            pos.write(123);
        }
        catch (IOException ex) {
            throw new IOException("Stream=" + os, ex);
        }
    }

    @Test(expected=IOException.class)
    public void testNoReaderBehaviourP() throws IOException {
        try (PipedOutputStream pos = new PipedOutputStream(1024);){
            pos.write(123);
        }
    }

    @Test(expected=IOException.class)
    public void testNoReaderBehaviour2() throws IOException {
        try (PipedOutputStream pos = new PipedOutputStream(1024);){
            try (InputStream is = pos.getInputStream();){
                pos.write(123);
                pos.flush();
                int val = is.read();
                Assert.assertEquals((long)123L, (long)val);
            }
            pos.write(123);
        }
    }
}

