/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.jmx;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.InvalidObjectException;
import java.io.NotSerializableException;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Future;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.ComparablePair;
import org.spf4j.base.Pair;
import org.spf4j.jmx.JMXBeanMapping;
import org.spf4j.jmx.RecursiveTestBean;
import org.spf4j.jmx.mappers.Spf4jOpenTypeMapper;
import org.spf4j.test2.avro.SampleNode;
import org.spf4j.tsdb2.avro.ColumnDef;
import org.spf4j.tsdb2.avro.TableDef;
import org.spf4j.tsdb2.avro.Type;

@SuppressFBWarnings(value={"SE_BAD_FIELD_INNER_CLASS", "SIC_INNER_SHOULD_BE_STATIC_ANON"})
public class OpenTypeConverterTest {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTypeConverterTest.class);
    private final Spf4jOpenTypeMapper conv = new Spf4jOpenTypeMapper();

    @Test
    public void testConverter() throws NotSerializableException {
        JMXBeanMapping mxBeanMapping = this.conv.get(File.class);
        Assert.assertNull((Object)mxBeanMapping);
    }

    @Test
    public void testConverter2() throws NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(ColumnDef[].class);
        Assert.assertNotNull((Object)mxBeanMapping2);
    }

    @Test
    public void testConverterPrimArray() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(int[].class);
        Assert.assertNotNull((Object)mxBeanMapping2);
        Object obj = mxBeanMapping2.toOpenValue((Object)new int[]{1, 2, 3});
        Object fromOpenValue = mxBeanMapping2.fromOpenValue(obj);
        Assert.assertArrayEquals((int[])new int[]{1, 2, 3}, (int[])((int[])fromOpenValue));
    }

    @Test
    public void testConverterAvroArray() throws OpenDataException, NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(TableDef[].class);
        Assert.assertNotNull((Object)mxBeanMapping2);
        TableDef[] defs = new TableDef[]{TableDef.newBuilder().setId(4L).setDescription("bla").setName("name").setSampleTime(10).setColumns(Arrays.asList(ColumnDef.newBuilder().setName("bla").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build())).build()};
        Object toOpenValue = mxBeanMapping2.toOpenValue((Object)defs);
        LOG.debug("Open value {} from {}", toOpenValue, (Object)defs);
    }

    @Test
    public void testConverterSet() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(new TypeToken<Set<TableDef>>(){}.getType());
        Assert.assertNotNull((Object)mxBeanMapping2);
        Object toOpenValue = mxBeanMapping2.toOpenValue((Object)ImmutableSet.of((Object)TableDef.newBuilder().setId(4L).setDescription("bla").setName("name").setSampleTime(10).setColumns(Arrays.asList(ColumnDef.newBuilder().setName("bla").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build())).build()));
        LOG.debug("OpenValue = {}", toOpenValue);
        Object fromOpenValue = mxBeanMapping2.fromOpenValue(toOpenValue);
        LOG.debug("Back to object = {}", fromOpenValue);
        Assert.assertTrue((String)("must be set, not " + fromOpenValue.getClass()), (boolean)(fromOpenValue instanceof Set));
    }

    @Test
    public void testConverterIterable() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(new TypeToken<Iterable<TableDef>>(){}.getType());
        Assert.assertNotNull((Object)mxBeanMapping2);
        Object toOpenValue = mxBeanMapping2.toOpenValue((Object)ImmutableSet.of((Object)TableDef.newBuilder().setId(4L).setDescription("bla").setName("name").setSampleTime(10).setColumns(Arrays.asList(ColumnDef.newBuilder().setName("bla").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build())).build()));
        LOG.debug("To open value: {}", toOpenValue);
        Object fromOpenValue = mxBeanMapping2.fromOpenValue(toOpenValue);
        LOG.debug("Back to object: {}", fromOpenValue);
        Assert.assertTrue((String)("must be Iterable, not " + fromOpenValue.getClass()), (boolean)(fromOpenValue instanceof Iterable));
    }

    @Test
    public void testConverterList() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(new TypeToken<List<ColumnDef>>(){}.getType());
        Assert.assertNotNull((Object)mxBeanMapping2);
        Object ov = mxBeanMapping2.toOpenValue(Arrays.asList(ColumnDef.newBuilder().setName("bla").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build()));
        LOG.debug("OpenValue = {}", ov);
        mxBeanMapping2.fromOpenValue(ov);
    }

    @Test
    public void testConverterFuture() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping map = this.conv.get(new TypeToken<Future<Integer>>(){}.getType());
        Assert.assertNull((Object)map);
    }

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testConverterMap() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(new TypeToken<Map<String, ColumnDef>>(){}.getType());
        Assert.assertNotNull((Object)mxBeanMapping2);
        Object ov = mxBeanMapping2.toOpenValue((Object)ImmutableMap.of((Object)"k1", (Object)ColumnDef.newBuilder().setName("bla").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build(), (Object)"K2", (Object)ColumnDef.newBuilder().setName("bla2").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build()));
        LOG.debug("OpenValue = {}", ov);
        mxBeanMapping2.fromOpenValue(ov);
    }

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testConverterProperties() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(Properties.class);
        Assert.assertNotNull((Object)mxBeanMapping2);
        Properties props = new Properties();
        props.setProperty("K", "V");
        Object ov = mxBeanMapping2.toOpenValue((Object)props);
        LOG.debug("Open Value = {}", ov);
        Properties properties = (Properties)mxBeanMapping2.fromOpenValue(ov);
        Assert.assertEquals((Object)props, (Object)properties);
    }

    @Test
    public void testConverterMapStrObject() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(new TypeToken<Map<String, ? extends Serializable>>(){}.getType());
        Assert.assertNull((Object)mxBeanMapping2);
    }

    @Test
    public void testConverterMapStrObject2() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping get = this.conv.get(new TypeToken<Map<String, Object>>(){}.getType());
        Assert.assertNull((Object)get);
    }

    @Test
    public void testConverterMapStrObject3() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(Map.class);
        Assert.assertNull((Object)mxBeanMapping2);
    }

    @Test
    public void testComparablePair() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(new TypeToken<ComparablePair<Integer, TableDef>>(){}.getType());
        Assert.assertNotNull((Object)mxBeanMapping2);
        Object ov = mxBeanMapping2.toOpenValue((Object)Pair.of((Object)3, (Object)TableDef.newBuilder().setId(4L).setDescription("bla").setName("name").setSampleTime(10).setColumns(Arrays.asList(ColumnDef.newBuilder().setName("bla").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build())).build()));
        ComparablePair pair = (ComparablePair)mxBeanMapping2.fromOpenValue(ov);
        Assert.assertEquals((long)3L, (long)((Integer)pair.getFirst()).longValue());
    }

    @Test
    public void testListSerializablePair() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping mxBeanMapping2 = this.conv.get(new TypeToken<List<ComparablePair<Integer, TableDef>>>(){}.getType());
        Assert.assertNotNull((Object)mxBeanMapping2);
        Object ov = mxBeanMapping2.toOpenValue(Arrays.asList(Pair.of((Object)3, (Object)TableDef.newBuilder().setId(4L).setDescription("bla").setName("name").setSampleTime(10).setColumns(Arrays.asList(ColumnDef.newBuilder().setName("bla").setType(Type.LONG).setDescription("bla").setUnitOfMeasurement("um").build())).build())));
        List res = (List)mxBeanMapping2.fromOpenValue(ov);
        ComparablePair pair = (ComparablePair)res.get(0);
        Assert.assertEquals((long)3L, (long)((Integer)pair.getFirst()).longValue());
    }

    @Test(expected=NotSerializableException.class)
    public void testConverterRecursiveData() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping get = this.conv.get(RecursiveTestBean.class);
        LOG.debug("Mapping = {}", (Object)get);
    }

    @Test
    public void testConverterRecursiveAvro() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping get = this.conv.get(org.spf4j.test.avro.SampleNode.class);
        Assert.assertNull((Object)get);
    }

    @Test
    public void testConverterRecursiveAvro2() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping get = this.conv.get(SampleNode.class);
        Assert.assertNull((Object)get);
    }

    @Test
    public void testConverterFile() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping get = this.conv.get(File.class);
        Assert.assertNull((Object)get);
    }

    @Test
    public void testJdkLocalDate() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping get = this.conv.get(LocalDate.class);
        Assert.assertNotNull((Object)get);
        LocalDate now = LocalDate.now();
        Object ov = get.toOpenValue((Object)now);
        LOG.debug("Open Value = {}", ov);
        Assert.assertTrue((boolean)(ov instanceof CompositeData));
    }

    @Test
    public void testCompositeData() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping get = this.conv.get(CompositeData.class);
        Assert.assertNotNull((Object)get);
    }

    @Test
    public void testCompositeDataSupport() throws OpenDataException, InvalidObjectException, NotSerializableException {
        JMXBeanMapping get = this.conv.get(CompositeDataSupport.class);
        Assert.assertNotNull((Object)get);
    }
}

