/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.net;

import java.io.IOException;
import java.time.Instant;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.net.SntpClient;
import org.spf4j.net.Timing;

@NotThreadSafe
public final class SntpClientTest {
    private static final Logger LOG = LoggerFactory.getLogger(SntpClientTest.class);

    @Test
    public void test() throws IOException, InterruptedException, TimeoutException {
        Timing requestTime = SntpClient.requestTimeHA((int)60000, (String[])new String[]{"time.apple.com"});
        long currentTimeMachine = System.currentTimeMillis();
        long currentTimeNtp = requestTime.getTime();
        LOG.debug("Current time machine = {} ", (Object)Instant.ofEpochMilli(currentTimeMachine));
        LOG.debug("Current time ntp = {} ", (Object)Instant.ofEpochMilli(currentTimeNtp));
        Assert.assertTrue((Math.abs(currentTimeNtp - currentTimeMachine) < 10000L ? 1 : 0) != 0);
    }
}

