/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf.impl.ms.tsdb;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.perf.MeasurementsInfo;
import org.spf4j.perf.impl.MeasurementsInfoImpl;
import org.spf4j.perf.impl.ms.tsdb.TSDBTxtMeasurementStore;

public class TSDBTxtMeasurementStoreTest {
    private static final Logger LOG = LoggerFactory.getLogger(TSDBTxtMeasurementStoreTest.class);

    @Test
    public void testCreateAppend() throws IOException {
        Path tmpFile = Paths.get(Runtime.TMP_FOLDER, "testM.txt");
        File file = tmpFile.toFile();
        TSDBTxtMeasurementStore store = new TSDBTxtMeasurementStore(file);
        long id = store.alocateMeasurements((MeasurementsInfo)new MeasurementsInfoImpl((Object)"test", "bla", new String[]{"a", "b"}, new String[]{"ms", "ms"}), 10000);
        store.saveMeasurements(id, System.currentTimeMillis(), new long[]{3L, 4L});
        store.close();
        String content = Files.lines(tmpFile, Charsets.UTF_8).collect(Collectors.joining("\n"));
        LOG.debug("File Content: {}", (Object)content);
        Assert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"a,3,b,4"));
        TSDBTxtMeasurementStore store2 = new TSDBTxtMeasurementStore(file);
        store2.saveMeasurements(id, System.currentTimeMillis(), new long[]{5L, 6L});
        store2.close();
        content = Files.lines(tmpFile, Charsets.UTF_8).collect(Collectors.joining("\n"));
        Assert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"a,3,b,4"));
        Assert.assertThat((Object)content, (Matcher)Matchers.containsString((String)"a,5,b,6"));
    }
}

