/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"PREDICTABLE_RANDOM"})
public final class ExpensiveTestObject
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(ExpensiveTestObject.class);
    private static final AtomicInteger OBJ_COUNT = new AtomicInteger();
    private static volatile boolean failAll = false;
    private final long maxIdleMillis;
    private final int nrUsesToFailAfter;
    private final long minOperationMillis;
    private final long maxOperationMillis;
    private long lastTouchedTimeMillis;
    private int nrUses;
    private final String id;

    public static boolean isFAILALL() {
        return failAll;
    }

    public static void setFailAll(boolean failAll) {
        ExpensiveTestObject.failAll = failAll;
    }

    @SuppressFBWarnings(value={"STT_TOSTRING_STORED_IN_FIELD"})
    public ExpensiveTestObject(long maxIdleMillis, int nrUsesToFailAfter, long minOperationMillis, long maxOperationMillis) {
        this.maxIdleMillis = maxIdleMillis;
        this.nrUsesToFailAfter = nrUsesToFailAfter;
        this.minOperationMillis = minOperationMillis;
        this.maxOperationMillis = maxOperationMillis;
        this.lastTouchedTimeMillis = System.currentTimeMillis();
        this.nrUses = 0;
        this.simulateDoStuff(maxOperationMillis - minOperationMillis);
        this.id = "Test Object " + OBJ_COUNT.getAndIncrement();
    }

    public void doStuff() throws IOException {
        if (failAll) {
            throw new IOExceptionImpl("Failall " + this.id);
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTouchedTimeMillis > this.maxIdleMillis) {
            throw new ClosedChannelException();
        }
        if (this.nrUses > this.nrUsesToFailAfter) {
            throw new IOExceptionImpl("Simulated random crap " + this.id);
        }
        this.simulateDoStuff(this.maxOperationMillis - this.minOperationMillis);
        ++this.nrUses;
        this.lastTouchedTimeMillis = System.currentTimeMillis();
    }

    public void testObject() throws IOException {
        LOG.debug("Testing object {}", (Object)this.id);
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastTouchedTimeMillis > this.maxIdleMillis) {
            throw new IOException("Connection closed " + this.id);
        }
        if (this.nrUses > this.nrUsesToFailAfter) {
            throw new IOExceptionImpl("Simulated random crap " + this.id);
        }
        this.simulateDoStuff(0L);
        ++this.nrUses;
        this.lastTouchedTimeMillis = System.currentTimeMillis();
    }

    @Override
    public void close() throws IOException {
        this.doStuff();
    }

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
    private void simulateDoStuff(long time) {
        long sleepTime = (long)(Math.random() * (double)time);
        try {
            Thread.sleep(this.minOperationMillis + sleepTime);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    public String toString() {
        return "ExpensiveTestObject{maxIdleMillis=" + this.maxIdleMillis + ", nrUsesToFailAfter=" + this.nrUsesToFailAfter + ", minOperationMillis=" + this.minOperationMillis + ", maxOperationMillis=" + this.maxOperationMillis + ", lastTouchedTimeMillis=" + this.lastTouchedTimeMillis + ", nrUses=" + this.nrUses + ", id=" + this.id + '}';
    }

    private static final class IOExceptionImpl
    extends IOException {
        IOExceptionImpl(String message) {
            super(message);
        }

        @Override
        public Throwable fillInStackTrace() {
            return this;
        }
    }
}

