/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.concurrent.NotThreadSafe;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.Throwables;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.concurrent.LifoThreadPoolExecutorSQP;
import org.spf4j.failsafe.AsyncRetryExecutor;
import org.spf4j.failsafe.RetryPolicy;
import org.spf4j.failsafe.concurrent.RetryExecutor;
import org.spf4j.recyclable.ObjectBorrowException;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.ObjectReturnException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.impl.ExpensiveTestObject;
import org.spf4j.recyclable.impl.ExpensiveTestObjectFactory;
import org.spf4j.recyclable.impl.RecyclingSupplierBuilder;
import org.spf4j.recyclable.impl.TestCallable;

@SuppressFBWarnings(value={"MDM_THREAD_YIELD", "SIC_INNER_SHOULD_BE_STATIC_ANON"})
@NotThreadSafe
public final class ObjectPoolBuilderTest {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectPoolBuilderTest.class);
    private volatile boolean isDeadlock = false;

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testBuild() throws ObjectCreationException, InterruptedException, ObjectBorrowException, TimeoutException, ObjectDisposeException {
        RecyclingSupplier pool = new RecyclingSupplierBuilder(10, (RecyclingSupplier.Factory)new ExpensiveTestObjectFactory()).build();
        LOG.debug("pool = {}", (Object)pool);
        ExpensiveTestObject object = (ExpensiveTestObject)pool.get();
        LOG.debug("pool = {}", (Object)pool);
        pool.recycle((Object)object, null);
        LOG.debug("pool = {}", (Object)pool);
        ExpensiveTestObject object2 = (ExpensiveTestObject)pool.get();
        Assert.assertSame((Object)object2, (Object)object);
        pool.dispose();
    }

    @Test(expected=IllegalStateException.class)
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testBuildDisposeTimeout() throws ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException, ObjectReturnException, ObjectDisposeException {
        RecyclingSupplier pool = new RecyclingSupplierBuilder(10, (RecyclingSupplier.Factory)new ExpensiveTestObjectFactory()).build();
        LOG.debug("pool = {}", (Object)pool);
        pool.get();
        pool.get();
        LOG.debug("pool = {}", (Object)pool);
        try (ExecutionContext start = ExecutionContexts.start((long)1L, (TimeUnit)TimeUnit.SECONDS);){
            pool.dispose();
            pool.get();
            LOG.debug("pool = {}", (Object)pool);
        }
    }

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testBuild2() throws ObjectCreationException, InterruptedException, ObjectBorrowException, ExecutionException, TimeoutException {
        RecyclingSupplier pool = new RecyclingSupplierBuilder(10, (RecyclingSupplier.Factory)new ExpensiveTestObjectFactory()).withMaintenance(DefaultScheduler.INSTANCE, 1L, true).build();
        LOG.debug("pool = {}", (Object)pool);
        ExpensiveTestObject object = (ExpensiveTestObject)pool.get();
        LOG.debug("pool = {}", (Object)pool);
        Future<Void> submit = DefaultExecutor.INSTANCE.submit(() -> {
            pool.recycle((Object)object, null);
            return null;
        });
        submit.get();
        Thread.sleep(100L);
        ExpensiveTestObject object2 = (ExpensiveTestObject)pool.get();
        LOG.debug("pool = {}", (Object)pool);
        Assert.assertNotNull((Object)object2);
    }

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testBuild3() throws ObjectCreationException, InterruptedException, ObjectBorrowException, ExecutionException, TimeoutException {
        RecyclingSupplier pool = new RecyclingSupplierBuilder(10, (RecyclingSupplier.Factory)new ExpensiveTestObjectFactory()).withMaintenance(DefaultScheduler.INSTANCE, 1L, true).build();
        LOG.debug("pool = {}", (Object)pool);
        ExpensiveTestObject object = (ExpensiveTestObject)pool.get();
        LOG.debug("pool = {}", (Object)pool);
        Future<Void> submit = DefaultExecutor.INSTANCE.submit(() -> {
            pool.recycle((Object)object, null);
            return null;
        });
        submit.get();
        ExpensiveTestObject object2 = (ExpensiveTestObject)pool.get();
        LOG.debug("pool = {}", (Object)pool);
        Assert.assertSame((Object)object, (Object)object2);
    }

    @Test(timeout=20000L)
    public void testPoolUseNoFailures() throws ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException, ObjectReturnException, ObjectDisposeException, ExecutionException {
        RecyclingSupplier pool = new RecyclingSupplierBuilder(10, (RecyclingSupplier.Factory)new ExpensiveTestObjectFactory(1000000L, 1000000, 1L, 5L)).build();
        this.runTest((RecyclingSupplier<ExpensiveTestObject>)pool, 0L, 10000L);
        pool.dispose();
    }

    @Test(timeout=16000L)
    public void testPoolUseNoFailuresStarvation() throws ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException, ObjectReturnException, ObjectDisposeException, ExecutionException {
        RecyclingSupplier pool = new RecyclingSupplierBuilder(1, (RecyclingSupplier.Factory)new ExpensiveTestObjectFactory(1000000L, 1000000, 1L, 5L)).build();
        this.runTest((RecyclingSupplier<ExpensiveTestObject>)pool, 0L, 15000L);
        pool.dispose();
    }

    @Test(timeout=20000L)
    public void testPoolUse() throws ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException, ObjectReturnException, ObjectDisposeException, ExecutionException {
        RecyclingSupplier pool = new RecyclingSupplierBuilder(10, (RecyclingSupplier.Factory)new ExpensiveTestObjectFactory()).build();
        this.runTest((RecyclingSupplier<ExpensiveTestObject>)pool, 0L, 10000L);
        try {
            ExpensiveTestObject.setFailAll(true);
            pool.dispose();
            Assert.fail();
        }
        catch (ObjectDisposeException ex) {
            Throwables.writeTo((Throwable)ex, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
        }
        finally {
            ExpensiveTestObject.setFailAll(false);
        }
    }

    @Test(timeout=20000L)
    public void testPoolUseWithMaintenance() throws ObjectCreationException, ObjectBorrowException, InterruptedException, TimeoutException, ObjectReturnException, ObjectDisposeException, ExecutionException {
        RecyclingSupplier pool = new RecyclingSupplierBuilder(10, (RecyclingSupplier.Factory)new ExpensiveTestObjectFactory()).withMaintenance(DefaultScheduler.INSTANCE, 10L, true).build();
        this.runTest((RecyclingSupplier<ExpensiveTestObject>)pool, 5L, 20000L);
        try {
            pool.dispose();
        }
        catch (ObjectDisposeException ex) {
            Throwables.writeTo((Throwable)ex, (PrintStream)System.err, (Throwables.PackageDetail)Throwables.PackageDetail.SHORT);
        }
    }

    private Thread startDeadlockMonitor(RecyclingSupplier<ExpensiveTestObject> pool, long deadlockTimeout) {
        this.isDeadlock = false;
        Thread monitor = new Thread(() -> {
            try {
                Thread.sleep(deadlockTimeout);
                ThreadMXBean threadMX = ManagementFactory.getThreadMXBean();
                LOG.debug("Thread Info: {}", (Object[])threadMX.dumpAllThreads(true, true));
                LOG.debug("Pool = {}", (Object)pool);
                this.isDeadlock = true;
            }
            catch (InterruptedException ex) {
                return;
            }
        });
        monitor.start();
        return monitor;
    }

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
    private void runTest(RecyclingSupplier<ExpensiveTestObject> pool, long sleepBetweenSubmit, long deadlockTimeout) throws InterruptedException, ExecutionException {
        int i;
        Thread monitor = this.startDeadlockMonitor(pool, deadlockTimeout);
        LifoThreadPoolExecutorSQP execService = new LifoThreadPoolExecutorSQP("test", 10, 10, 5000, 1024, true);
        LinkedBlockingDeque completionQueue = new LinkedBlockingDeque();
        RetryExecutor exec = new RetryExecutor((ExecutorService)execService, completionQueue);
        AsyncRetryExecutor policy = RetryPolicy.newBuilder().withDefaultThrowableRetryPredicate().buildAsync(exec);
        int nrTests = 1000;
        for (i = 0; i < nrTests; ++i) {
            policy.execute((Callable)new TestCallable(pool, i));
            Thread.sleep(sleepBetweenSubmit);
        }
        for (i = 0; i < nrTests; ++i) {
            LOG.debug("Done({})", ((Future)completionQueue.take()).get());
        }
        monitor.interrupt();
        monitor.join();
        Thread.sleep(100L);
        Assert.assertEquals((long)0L, (long)completionQueue.size());
        if (this.isDeadlock) {
            Assert.fail((String)"deadlock detected");
        }
        exec.close();
    }
}

