/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.NotThreadSafe;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.ExitException;
import org.spf4j.base.NoExitSecurityManager;
import org.spf4j.stackmonitor.Monitor;

@SuppressFBWarnings(value={"PREDICTABLE_RANDOM"})
@NotThreadSafe
public final class MonitorTest {
    private static volatile boolean stopped;
    private SecurityManager original;

    @Before
    public void init() {
        this.original = System.getSecurityManager();
        System.setSecurityManager((SecurityManager)new NoExitSecurityManager());
        Thread.setDefaultUncaughtExceptionHandler((t, e) -> {
            StringWriter strw = new StringWriter();
            e.printStackTrace(new PrintWriter(strw));
            Assert.fail((String)("Got Exception: " + strw));
        });
    }

    @After
    public void cleanup() {
        System.setSecurityManager(this.original);
    }

    @Test(expected=ExitException.class)
    public void testError() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, IOException {
        String report = File.createTempFile("stackSample", ".html").getPath();
        System.setSecurityManager((SecurityManager)new NoExitSecurityManager());
        Monitor.main((String[])new String[]{"-ASDF", "-f", report, "-ss", "-si", "10", "-w", "600", "-main", MonitorTest.class.getName()});
    }

    @Test
    public void testJmx() throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        try {
            Monitor.main((String[])new String[]{"-ss", "-si", "10", "-main", MonitorTest.class.getName()});
        }
        catch (ExitException ex) {
            Assert.assertEquals((long)0L, (long)ex.getExitCode());
        }
    }

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
    public static void main(String[] args) throws InterruptedException {
        stopped = false;
        try (final ExecutionContext ctx = ExecutionContexts.start((String)"main", (long)10L, (TimeUnit)TimeUnit.MINUTES);){
            ArrayList<Thread> threads = new ArrayList<Thread>(20);
            for (int i = 0; i < 20; ++i) {
                Thread t = new Thread((Runnable)new AbstractRunnable(){

                    public void doRun() throws InterruptedException {
                        try (ExecutionContext tctx = ExecutionContexts.start((String)"testThread", (ExecutionContext)ctx, (long)10L, (TimeUnit)TimeUnit.MINUTES);){
                            while (!stopped) {
                                double rnd = Math.random();
                                if (rnd < 0.33) {
                                    this.doStuff1(rnd, 50);
                                    continue;
                                }
                                if (rnd < 0.66) {
                                    this.doStuff2(rnd);
                                    continue;
                                }
                                this.doStuff3(rnd);
                            }
                        }
                    }

                    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
                    private double doStuff3(double rnd) throws InterruptedException {
                        Thread.sleep(1L);
                        if (rnd > 0.8) {
                            this.doStuff2(rnd);
                        }
                        return rnd * Math.pow(2.0, 10000.0);
                    }

                    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
                    private double doStuff2(double prnd) throws InterruptedException {
                        double rnd = prnd;
                        Thread.sleep(1L);
                        for (int j = 0; j < 10000; ++j) {
                            rnd += rnd;
                        }
                        return rnd;
                    }

                    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
                    private void doStuff1(double rnd, int depth) throws InterruptedException {
                        if (depth <= 0) {
                            Thread.sleep(10L);
                        } else {
                            this.doStuff1(rnd, depth - 1);
                        }
                    }
                }, "Thread" + i);
                t.start();
                threads.add(t);
            }
            Thread.sleep(5000L);
            stopped = true;
            for (Thread t : threads) {
                t.join(3000L);
            }
        }
    }
}

