/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.stackmonitor.StackCollectorImpl;

public final class SimpleStackCollectorTest {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleStackCollectorTest.class);

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS", "ES_COMPARING_STRINGS_WITH_EQ"})
    public void testSample() {
        StackCollectorImpl instance = new StackCollectorImpl();
        StackTraceElement[] st1 = new StackTraceElement[]{new StackTraceElement("C1", "m1", "C1.java", 10), new StackTraceElement("C1", "m2", "C1.java", 11), new StackTraceElement("C1", "m3", "C1.java", 12)};
        instance.collect(st1);
        LOG.debug("Collector = {}", (Object)instance);
        Assert.assertEquals((long)4L, (long)instance.get().getNrNodes());
        StackTraceElement[] st2 = new StackTraceElement[]{new StackTraceElement("C1", "m1", "C1.java", 10)};
        instance.collect(st2);
        LOG.debug("Collector = {}", (Object)instance);
        Assert.assertEquals((long)5L, (long)instance.get().getNrNodes());
        StackTraceElement[] st3 = new StackTraceElement[]{new StackTraceElement("C2", "m1", "C2.java", 10), new StackTraceElement("C2", "m2", "C2.java", 11), new StackTraceElement("C2", "m3", "C2.java", 12)};
        instance.collect(st3);
        LOG.debug("Collector = {}", (Object)instance);
        StackTraceElement[] st4 = new StackTraceElement[]{new StackTraceElement("C1", "m1", "C1.java", 10), new StackTraceElement("C1", "m2", "C1.java", 11), new StackTraceElement("C1", "m4", "C1.java", 14)};
        instance.collect(st4);
        LOG.debug("Collector = {}", (Object)instance);
        Thread currentThread = Thread.currentThread();
        Assert.assertSame((Object)currentThread.getStackTrace()[0].getClassName(), (Object)currentThread.getStackTrace()[0].getClassName());
        Assert.assertSame((Object)currentThread.getStackTrace()[0].getMethodName(), (Object)currentThread.getStackTrace()[0].getMethodName());
    }
}

