/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.text;

import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.text.MessageFormat;

public class FastMessageFormatTest {
    @Test
    public void testFormatter() throws IOException {
        StringBuilder sb = new StringBuilder();
        MessageFormat format = new MessageFormat("{0}, {1}");
        format.format(new Object[]{"a", "b"}, (CharSequence)sb, null);
        Assert.assertEquals((Object)"a, b", (Object)sb.toString());
    }

    @Test
    public void testFormatter5() throws IOException {
        StringBuilder sb = new StringBuilder();
        MessageFormat format = new MessageFormat("{0}, {1}, {2}, {3}, {4}");
        format.format(new Object[]{"a", "b", "c", "d", "e"}, (CharSequence)sb, null);
        Assert.assertEquals((Object)"a, b, c, d, e", (Object)sb.toString());
    }

    @Test
    public void testFormatter2() throws IOException {
        StringBuilder sb = new StringBuilder();
        MessageFormat format = new MessageFormat("bla bla bla");
        format.format(null, (CharSequence)sb, null);
        Assert.assertEquals((Object)"bla bla bla", (Object)sb.toString());
    }

    @Test
    public void testFormatter3() throws IOException {
        StringBuilder sb = new StringBuilder();
        MessageFormat format = new MessageFormat("pre {1}, {0} suf");
        format.format(new Object[]{"a", "b"}, (CharSequence)sb, null);
        Assert.assertEquals((Object)"pre b, a suf", (Object)sb.toString());
    }

    @Test
    public void testFormatter4() throws IOException {
        StringBuilder sb = new StringBuilder();
        MessageFormat format = new MessageFormat("pre {1}, {0}, {2,number,$'#',##} suf");
        format.format(new Object[]{"a", "b", 100}, (CharSequence)sb, null);
        Assert.assertEquals((Object)"pre b, a, $#1,00 suf", (Object)sb.toString());
    }
}

