/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.unix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.unix.JVMArguments;

public class JVMArgumentsTest {
    private static final Logger LOG = LoggerFactory.getLogger(JVMArgumentsTest.class);

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testCurrentArgs() throws IOException {
        Assume.assumeFalse((boolean)Runtime.isWindows());
        JVMArguments current = JVMArguments.current();
        LOG.debug("Current jvm args: {}", (Object)current);
        Assert.assertThat((Object)current.getExecutable(), (Matcher)Matchers.endsWith((String)"java"));
        current.setVMArgument("-Xbla");
        Assert.assertTrue((boolean)current.hasVMArgument("-Xbla"));
        Assert.assertTrue((boolean)current.hasVMArgumentStartingWith("-Xb"));
        Assert.assertTrue((boolean)current.removeVMArgument("-Xbla"));
        Assert.assertFalse((boolean)current.hasVMArgument("-Xbla"));
        current.createOrUpdateSystemProperty("spf4j.restart", old -> old == null ? "1" : Integer.toString(Integer.parseInt(old) + 1));
        Assert.assertEquals((Object)"1", (Object)current.getSystemProperty("spf4j.restart"));
        current.createOrUpdateSystemProperty("spf4j.restart", old -> old == null ? "1" : Integer.toString(Integer.parseInt(old) + 1));
        Assert.assertEquals((Object)"2", (Object)current.getSystemProperty("spf4j.restart"));
        Assert.assertEquals((Object)"2", (Object)current.removeSystemProperty("spf4j.restart"));
        Assert.assertNull((Object)current.getSystemProperty("spf4j.restart"));
    }
}

