/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.base.CharSequences;
import org.spf4j.base.Strings;
import org.spf4j.test.log.Level;
import org.spf4j.test.log.LogAssert;
import org.spf4j.test.log.LogRecord;
import org.spf4j.test.log.TestLoggers;

public final class StringsTest {
    @Test
    public void testDistance() {
        Assert.assertEquals((long)3L, (long)Strings.distance((String)"abc", (String)"abcdef"));
        Assert.assertEquals((long)3L, (long)Strings.distance((String)"def", (String)"abcdef"));
        Assert.assertEquals((long)1L, (long)Strings.distance((String)"abc", (String)"bc"));
        Assert.assertEquals((long)3L, (long)Strings.distance((String)"abc", (String)"def"));
        Assert.assertEquals((long)1L, (long)Strings.distance((String)"zoltran", (String)"zoltan"));
    }

    @Test
    public void testEscaping() {
        String res = Strings.unescape((String)"a\\n");
        Assert.assertEquals((Object)"a\n", (Object)res);
    }

    @Test
    public void testUnsafeOps() {
        LogAssert dontExpect = TestLoggers.sys().dontExpect(Strings.class.getName(), Level.INFO, new Matcher[]{Matchers.any(LogRecord.class)});
        String testString = "dfjgdjshfgsjdhgfskhdfkdshf\ndfs@#$%^&\u63a5\u53d7*($%^&*()(*&^%$#@!>::><>?{PLKJHGFDEWSDFG";
        char[] chars = Strings.steal((String)testString);
        String otherString = Strings.wrap((char[])chars);
        Assert.assertEquals((Object)testString, (Object)otherString);
        byte[] bytes = Strings.toUtf8((String)testString);
        otherString = Strings.fromUtf8((byte[])bytes);
        Assert.assertEquals((Object)testString, (Object)otherString);
        dontExpect.assertObservation();
    }

    @Test
    public void testSubSequence() {
        String str = "dsfhjgsdjfgwuergfedhgfjhwheriufwiueruhfguyerugfweuyrygfwueyrghfuwoeruhgfdgwsjhfg";
        Assert.assertEquals((long)0L, (long)CharSequences.compare((CharSequence)str, (int)3, (int)12, (CharSequence)str, (int)3, (int)12));
        Assert.assertTrue((boolean)Strings.equals((CharSequence)str.subSequence(15, 15), (CharSequence)Strings.subSequence((CharSequence)str, (int)15, (int)15)));
        Assert.assertTrue((boolean)Strings.equals((CharSequence)str.subSequence(0, str.length()), (CharSequence)Strings.subSequence((CharSequence)str, (int)0, (int)str.length())));
        Assert.assertEquals((Object)str.subSequence(3, 15).toString(), (Object)Strings.subSequence((CharSequence)str, (int)3, (int)15).toString());
    }

    @Test
    public void testEndsWith() {
        Assert.assertTrue((boolean)Strings.endsWith((CharSequence)"dfjkshfks", (CharSequence)"hfks"));
        Assert.assertTrue((boolean)Strings.endsWith((CharSequence)"dfjkshfks", (CharSequence)""));
        Assert.assertFalse((boolean)Strings.endsWith((CharSequence)"dfjkshfks", (CharSequence)"hfk"));
        Assert.assertTrue((boolean)Strings.endsWith((CharSequence)"dfjkshfks", (CharSequence)"dfjkshfks"));
        Assert.assertFalse((boolean)Strings.endsWith((CharSequence)"dfjkshfks", (CharSequence)"dfjkshfksu"));
    }

    @Test
    public void testEncoding() {
        StringBuilder sb = new StringBuilder();
        Strings.appendUnsignedString((StringBuilder)sb, (int)38, (int)4);
        Assert.assertEquals((Object)Integer.toHexString(38), (Object)sb.toString());
    }

    @Test
    public void testEncoding2() {
        StringBuilder sb = new StringBuilder();
        Strings.appendUnsignedStringPadded((StringBuilder)sb, (int)38, (int)5, (int)4);
        Assert.assertEquals((long)4L, (long)sb.length());
    }

    @Test
    public void testJsonEncoding() {
        StringBuilder sb = new StringBuilder();
        sb.append('\"');
        Strings.escapeJsonString((String)"\n\b\u0000abc\"", (StringBuilder)sb);
        sb.append('\"');
        Assert.assertEquals((Object)"\"\\n\\b\\u0000abc\\\"\"", (Object)sb.toString());
    }
}

