/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.concurrent.LifoThreadPoolExecutorSQP;

public class ThreadPoolExecutorTest {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadPoolExecutorTest.class);

    @Test(timeout=10000L)
    public void testInteruptionBehavior() throws InterruptedException, ExecutionException {
        LifoThreadPoolExecutorSQP executor = new LifoThreadPoolExecutorSQP("test", 0, 16, 60000, 0);
        ThreadPoolExecutorTest.testPoolTaskCancellation((ExecutorService)executor);
    }

    @Test(timeout=10000L)
    public void testInteruptionBehaviorFJP() throws InterruptedException, ExecutionException {
        boolean assertError = false;
        try {
            ThreadPoolExecutorTest.testPoolTaskCancellation(new ForkJoinPool(16));
        }
        catch (AssertionError err) {
            LOG.debug("Expected error", (Throwable)((Object)err));
            assertError = true;
        }
        Assert.assertTrue((String)"expected that FJP tasks cannot be interrupted", (boolean)assertError);
    }

    public static void testPoolTaskCancellation(ExecutorService executor) throws InterruptedException, ExecutionException {
        RunnableImpl testRunnable = new RunnableImpl();
        Future<?> submit = executor.submit(testRunnable);
        Assert.assertTrue((String)"task did not start", (boolean)testRunnable.getStartedlatch().await(5L, TimeUnit.SECONDS));
        submit.cancel(true);
        try {
            submit.get();
            Assert.fail((String)"expected CancellationException");
        }
        catch (CancellationException cancellationException) {
            // empty catch block
        }
        Assert.assertTrue((String)"task was not interrupted", (boolean)testRunnable.getInterruptedLatch().await(5L, TimeUnit.SECONDS));
        executor.shutdown();
        Assert.assertTrue((String)"executor was not shut down", (boolean)executor.awaitTermination(1000L, TimeUnit.MILLISECONDS));
    }

    static class RunnableImpl
    implements Runnable {
        private CountDownLatch startedlatch = new CountDownLatch(1);
        private CountDownLatch interruptedLatch = new CountDownLatch(1);

        RunnableImpl() {
        }

        @Override
        @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
        public void run() {
            this.startedlatch.countDown();
            try {
                Thread.sleep(100000L);
            }
            catch (InterruptedException ex) {
                this.interruptedLatch.countDown();
            }
        }

        public CountDownLatch getInterruptedLatch() {
            return this.interruptedLatch;
        }

        public CountDownLatch getStartedlatch() {
            return this.startedlatch;
        }
    }
}

