/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.ds;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Iterator;
import java.util.PriorityQueue;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.base.MutableHolder;
import org.spf4j.ds.UpdateablePriorityQueue;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
public final class UpdateablePriorityQueueTest {
    @Test
    public void test1() {
        UpdateablePriorityQueue queue = new UpdateablePriorityQueue(4);
        queue.add((Object)1);
        queue.add((Object)2);
        queue.add((Object)3);
        queue.add((Object)4);
        Assert.assertEquals((Object)1, (Object)queue.poll());
        Assert.assertNotEquals((Object)4, (Object)queue.poll());
    }

    @Test
    public void test1p() {
        PriorityQueue<Integer> queue = new PriorityQueue<Integer>(4);
        queue.add(1);
        queue.add(2);
        queue.add(3);
        queue.add(4);
        Assert.assertEquals((Object)1, queue.poll());
        Assert.assertNotEquals((Object)4, queue.poll());
    }

    @Test
    public void test2() {
        UpdateablePriorityQueue queue = new UpdateablePriorityQueue(0);
        queue.add((Object)4);
        queue.add((Object)3);
        queue.add((Object)2);
        queue.add((Object)1);
        Assert.assertEquals((Object)1, (Object)queue.poll());
        Assert.assertNotEquals((Object)4, (Object)queue.poll());
    }

    @Test
    public void test3() {
        UpdateablePriorityQueue queue = new UpdateablePriorityQueue(0);
        queue.add((Object)1);
        queue.add((Object)4);
        queue.add((Object)2);
        queue.add((Object)3);
        Assert.assertEquals((Object)1, (Object)queue.poll());
        Assert.assertNotEquals((Object)4, (Object)queue.poll());
    }

    @Test
    public void test4() {
        UpdateablePriorityQueue queue = new UpdateablePriorityQueue(0);
        UpdateablePriorityQueue.ElementRef add = queue.add((Object)1);
        queue.add((Object)4);
        queue.add((Object)2);
        queue.add((Object)3);
        add.setElem((Object)5);
        Assert.assertEquals((Object)2, (Object)queue.poll());
        Assert.assertEquals((long)3L, (long)queue.size());
        add.setElem((Object)1);
        queue.add((Object)10);
        Assert.assertEquals((Object)1, (Object)queue.poll());
        Assert.assertEquals((long)3L, (long)queue.size());
        queue.add((Object)0);
        Assert.assertEquals((Object)0, (Object)queue.poll());
        Assert.assertEquals((long)3L, (long)queue.size());
        Assert.assertNotEquals((Object)4, (Object)queue.poll());
    }

    @Test
    public void test5() {
        UpdateablePriorityQueue queue = new UpdateablePriorityQueue(0);
        queue.add((Object)1);
        UpdateablePriorityQueue.ElementRef add = queue.add((Object)4);
        queue.add((Object)2);
        queue.add((Object)3);
        add.setElem((Object)0);
        Assert.assertEquals((Object)0, (Object)queue.poll());
        Assert.assertEquals((long)3L, (long)queue.size());
    }

    @Test
    public void test6() {
        UpdateablePriorityQueue queue = new UpdateablePriorityQueue(0);
        queue.add((Object)new MutableHolder((Object)3));
        queue.add((Object)new MutableHolder((Object)2));
        queue.add((Object)new MutableHolder((Object)4));
        UpdateablePriorityQueue.ElementRef add = queue.add((Object)new MutableHolder((Object)1));
        UpdateablePriorityQueue.ElementRef add1 = queue.add((Object)new MutableHolder((Object)5));
        Assert.assertEquals((Object)1, (Object)((MutableHolder)queue.peek()).getValue());
        ((MutableHolder)add.getElem()).setValue((Object)10);
        add.elementMutated();
        Assert.assertEquals((Object)2, (Object)((MutableHolder)queue.peek()).getValue());
        ((MutableHolder)add1.getElem()).setValue((Object)0);
        add1.elementMutated();
        Assert.assertEquals((Object)0, (Object)((MutableHolder)queue.peek()).getValue());
        add1.remove();
        Assert.assertEquals((Object)2, (Object)((MutableHolder)queue.peek()).getValue());
    }

    @Test
    public void testRemove() {
        UpdateablePriorityQueue queue = new UpdateablePriorityQueue(0);
        MutableHolder value = new MutableHolder((Object)3);
        UpdateablePriorityQueue.ElementRef ref = queue.add((Object)value);
        MutableHolder four = new MutableHolder((Object)4);
        queue.add((Object)four);
        MutableHolder five = new MutableHolder((Object)5);
        queue.add((Object)five);
        MutableHolder six = new MutableHolder((Object)6);
        queue.add((Object)six);
        MutableHolder poll = (MutableHolder)queue.poll();
        Assert.assertEquals((Object)value, (Object)poll);
        Assert.assertFalse((boolean)ref.remove());
        Iterator iterator = queue.iterator();
        iterator.next();
        iterator.next();
        iterator.remove();
        iterator.next();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((long)2L, (long)queue.size());
    }
}

