/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.PermitSupplier;
import org.spf4j.failsafe.LimitingExecutor;
import org.spf4j.failsafe.RateLimiter;
import org.spf4j.test.log.Level;
import org.spf4j.test.log.LogAssert;
import org.spf4j.test.log.TestLoggers;
import org.spf4j.test.matchers.LogMatchers;

public class LimitingExecutorTest {
    private static final Logger LOG = LoggerFactory.getLogger(LimitingExecutorTest.class);

    @Test
    public void testRateLimit() throws Exception {
        LogAssert expect = TestLoggers.sys().expect(LimitingExecutorTest.class.getName(), Level.DEBUG, new Matcher[]{LogMatchers.hasFormat((String)"executed nr {}")});
        try (RateLimiter limiter = new RateLimiter(10.0, 10);){
            LimitingExecutor executor = new LimitingExecutor((PermitSupplier)limiter);
            Assert.assertEquals((double)1.0, (double)limiter.getPermitsPerReplenishInterval(), (double)0.001);
            Assert.assertEquals((double)100.0, (double)limiter.getPermitReplenishIntervalMillis(), (double)0.001);
            int i = 0;
            while (i < 10) {
                int val = i++;
                executor.execute(() -> {
                    LOG.debug("executed nr {}", (Object)val);
                    return null;
                });
            }
            Assert.fail();
        }
        catch (RejectedExecutionException ex) {
            expect.assertObservation();
        }
    }

    @Test
    public void testRateLimit2() throws Exception {
        LogAssert expect = TestLoggers.sys().expect(LimitingExecutorTest.class.getName(), Level.DEBUG, 10, new Matcher[]{LogMatchers.hasFormat((String)"executed nr {}")});
        try (final RateLimiter limiter = new RateLimiter(10.0, 10);){
            LimitingExecutor.RejectedExecutionHandler rejectedExecutionHandler = new LimitingExecutor.RejectedExecutionHandler(){

                @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
                public Object reject(LimitingExecutor executor, Callable callable) throws Exception {
                    long waitMs = limiter.getPermitReplenishIntervalMillis() - TimeUnit.NANOSECONDS.toMillis(TimeSource.nanoTime() - limiter.getLastReplenishmentNanos());
                    if (waitMs >= 0L) {
                        Thread.sleep(waitMs);
                    } else {
                        LOG.debug("negative wait time {}", (Object)waitMs);
                    }
                    return executor.execute(callable);
                }
            };
            LimitingExecutor executor = new LimitingExecutor(rejectedExecutionHandler, limiter.toSemaphore());
            int i = 0;
            while (i < 10) {
                int val = i++;
                executor.execute(() -> {
                    LOG.debug("executed nr {}", (Object)val);
                    return null;
                });
            }
        }
        expect.assertObservation();
    }
}

