/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.TimeSource;
import org.spf4j.failsafe.RateLimiter;
import org.spf4j.test.log.Level;
import org.spf4j.test.log.annotations.PrintLogs;

public class RateLimiterTest {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimiterTest.class);

    @Test(expected=IllegalArgumentException.class)
    public void testRateLimitInvalid() {
        new RateLimiter(1000.0, 9);
    }

    @Test
    @PrintLogs(ideMinLevel=Level.TRACE)
    public void testRateLimitArgs() {
        try (RateLimiter rateLimiter = new RateLimiter(17.0, 10, 10L);){
            LOG.debug("Rate Limiter = {}", (Object)rateLimiter);
            Assert.assertEquals((double)1.0, (double)rateLimiter.getPermitsPerReplenishInterval(), (double)0.001);
        }
        rateLimiter = new RateLimiter(1.0E7, 5000000, 500L);
        var2_2 = null;
        try {
            LOG.debug("Rate Limiter = {}", (Object)rateLimiter);
            Assert.assertEquals((long)500L, (long)rateLimiter.getPermitReplenishIntervalMillis());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (rateLimiter != null) {
                if (var2_2 != null) {
                    try {
                        rateLimiter.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    rateLimiter.close();
                }
            }
        }
    }

    @Test
    public void testRateLimitTryAcquisition() throws InterruptedException {
        try (RateLimiter rateLimiter = new RateLimiter(10.0, 10);){
            LOG.debug("Rate Limiter = {}", (Object)rateLimiter);
            Assert.assertFalse((boolean)rateLimiter.tryAcquire(20, 0L, TimeUnit.MILLISECONDS));
            long startTime = TimeSource.nanoTime();
            boolean tryAcquire = rateLimiter.tryAcquire(20, 2L, TimeUnit.SECONDS);
            LOG.debug("waited {} ns for {}", (Object)(TimeSource.nanoTime() - startTime), (Object)rateLimiter);
            Assert.assertTrue((boolean)tryAcquire);
            Assert.assertFalse((boolean)rateLimiter.tryAcquire(20, 1L, TimeUnit.SECONDS));
        }
    }

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testRateLimitTryAcquisition2() throws InterruptedException {
        ScheduledExecutorService mockExec = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ScheduledFuture mockFut = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when(mockExec.scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)100L), Mockito.eq((long)100L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))))).thenReturn((Object)mockFut);
        try (RateLimiter rateLimiter = new RateLimiter(10.0, 10, mockExec, () -> 0L);){
            long tryAcquireGetDelayMs = rateLimiter.tryAcquireGetDelayMillis(10, 10L, TimeUnit.SECONDS);
            LOG.debug("Rate Limiter = {}, waitMs = {}", (Object)rateLimiter, (Object)tryAcquireGetDelayMs);
            Assert.assertEquals((long)900L, (long)tryAcquireGetDelayMs);
            Assert.assertEquals((double)-9.0, (double)rateLimiter.getNrPermits(), (double)1.0E-4);
            tryAcquireGetDelayMs = rateLimiter.tryAcquireGetDelayMillis(10, 10L, TimeUnit.MILLISECONDS);
            Assert.assertTrue((tryAcquireGetDelayMs < 0L ? 1 : 0) != 0);
            tryAcquireGetDelayMs = rateLimiter.tryAcquireGetDelayMillis(1, 2000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((long)1000L, (long)tryAcquireGetDelayMs);
        }
        ((ScheduledExecutorService)Mockito.verify((Object)mockExec)).scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)100L), Mockito.eq((long)100L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((ScheduledFuture)Mockito.verify((Object)mockFut)).cancel(false);
    }

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testRateLimitTryAcquisition3() throws InterruptedException {
        ScheduledExecutorService mockExec = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ScheduledFuture mockFut = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when(mockExec.scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)10000L), Mockito.eq((long)10000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))))).thenReturn((Object)mockFut);
        try (RateLimiter rateLimiter = new RateLimiter(0.1, 10, mockExec, () -> 0L);){
            long tryAcquireGetDelayMs = rateLimiter.tryAcquireGetDelayMillis(2, 10L, TimeUnit.SECONDS);
            LOG.debug("Rate Limiter = {}, waitMs = {}", (Object)rateLimiter, (Object)tryAcquireGetDelayMs);
            Assert.assertEquals((long)10000L, (long)tryAcquireGetDelayMs);
            Assert.assertEquals((double)-1.0, (double)rateLimiter.getNrPermits(), (double)1.0E-4);
            tryAcquireGetDelayMs = rateLimiter.tryAcquireGetDelayMillis(1, 10L, TimeUnit.MILLISECONDS);
            Assert.assertTrue((tryAcquireGetDelayMs < 0L ? 1 : 0) != 0);
        }
        ((ScheduledExecutorService)Mockito.verify((Object)mockExec)).scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)10000L), Mockito.eq((long)10000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.MILLISECONDS))));
        ((ScheduledFuture)Mockito.verify((Object)mockFut)).cancel(false);
    }
}

