/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import com.google.common.net.HostAndPort;
import java.io.IOException;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.io.ConfigurableAppenderSupplier;
import org.spf4j.io.ObjectAppender;

public class ConfigurableAppenderSupplierTest {
    @Test
    public void testBehavior() {
        ConfigurableAppenderSupplier supplier = new ConfigurableAppenderSupplier();
        ObjectAppender objectAppender = (object, appendTo) -> appendTo.append("its an object!");
        ObjectAppender testObjAppender = (object, appendTo) -> appendTo.append("its my unit test!");
        ObjectAppender testObjAppender2 = (object, appendTo) -> appendTo.append((CharSequence)object);
        supplier.replace(Object.class, x -> objectAppender);
        supplier.register(ConfigurableAppenderSupplierTest.class, testObjAppender);
        supplier.replace(CharSequence.class, x -> testObjAppender2);
        Assert.assertEquals((Object)testObjAppender, (Object)supplier.get(ConfigurableAppenderSupplierTest.class));
        Assert.assertEquals((Object)objectAppender, (Object)supplier.get(Object.class));
        Assert.assertEquals((Object)testObjAppender2, (Object)supplier.get(String.class));
        Assert.assertEquals((Object)objectAppender, (Object)supplier.get(HostAndPort.class));
    }

    @Test
    public void testRegistration() throws IOException {
        ConfigurableAppenderSupplier appSupplier = new ConfigurableAppenderSupplier(false, x -> false, new ObjectAppender[]{new TestAppender()});
        StringBuilder builder = new StringBuilder();
        appSupplier.get(String.class).append((Object)"bla", (Appendable)builder);
        Assert.assertEquals((Object)"blaXX", (Object)builder.toString());
    }

    private static final class TestAppender
    implements ObjectAppender<Object> {
        private TestAppender() {
        }

        public void append(Object object, Appendable appendTo) throws IOException {
            appendTo.append(object.toString());
            appendTo.append("XX");
        }
    }
}

