/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.base.IntMath;
import org.spf4j.base.Strings;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.io.IOTimeoutException;
import org.spf4j.io.MemorizingBufferedInputStream;
import org.spf4j.io.PipedOutputStream;

public class PipedOutputStreamTest {
    private static final Logger LOG = LoggerFactory.getLogger(PipedOutputStreamTest.class);

    @Test
    public void testStreamPiping() throws IOException {
        PipedOutputStreamTest.test("This is a super cool, mega dupper test string for testing piping..........E", 8, false);
        IntMath.XorShift32 random = new IntMath.XorShift32();
        for (int i = 0; i < 100; ++i) {
            int nrChars = Math.abs(random.nextInt() % 100000);
            StringBuilder sb = PipedOutputStreamTest.generateTestStr(nrChars);
            PipedOutputStreamTest.test(sb.toString(), Math.abs(random.nextInt() % 10000) + 2, false);
        }
        PipedOutputStreamTest.test(PipedOutputStreamTest.generateTestStr(133).toString(), 2, false);
    }

    public static StringBuilder generateTestStr(int nrChars) {
        IntMath.XorShift32 random = new IntMath.XorShift32();
        StringBuilder sb = new StringBuilder(nrChars);
        for (int i = 0; i < nrChars; ++i) {
            sb.append((char)Math.abs(random.nextInt() % 100) + 20);
        }
        return sb;
    }

    public static void test(final String testStr, int buffSize, boolean buffered) throws IOException {
        final PipedOutputStream pos = new PipedOutputStream(buffSize);
        InputStream pis = buffered ? new MemorizingBufferedInputStream(pos.getInputStream()) : pos.getInputStream();
        DefaultExecutor.INSTANCE.execute((Runnable)new AbstractRunnable(){

            public void doRun() throws Exception {
                try (PipedOutputStream os = pos;){
                    byte[] utf8 = Strings.toUtf8((String)testStr);
                    os.write(utf8[0]);
                    os.write(utf8, 1, 10);
                    os.write(utf8, 11, utf8.length - 11);
                }
            }
        });
        StringBuilder sb = new StringBuilder();
        try (InputStream is = pis;){
            int read;
            byte[] buffer = new byte[1024];
            while ((read = is.read(buffer)) > 0) {
                sb.append(Strings.fromUtf8((byte[])buffer, (int)0, (int)read));
            }
        }
        Assert.assertEquals((Object)testStr, (Object)sb.toString());
    }

    @Test
    public void testNoReaderBehaviour() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        Future<Integer> nr;
        PipedOutputStream os = new PipedOutputStream(1024);
        int j = 0;
        try (PipedOutputStream pos = os;){
            pos.write(123);
            LOG.debug("write {}", (Object)j);
            ++j;
            nr = DefaultExecutor.instance().submit(() -> {
                try (InputStream is = pos.getInputStream();){
                    int val;
                    int i = 0;
                    while ((val = is.read()) >= 0) {
                        Assert.assertEquals((long)123L, (long)val);
                        LOG.debug("read {}", (Object)i);
                        ++i;
                    }
                    Integer n = i;
                    return n;
                }
            });
            while (j < 2000) {
                pos.write(123);
                LOG.debug("write {}", (Object)j);
                ++j;
            }
        }
        LOG.debug("os = {}", (Object)os);
        Assert.assertEquals((long)j, (long)nr.get(3L, TimeUnit.SECONDS).intValue());
    }

    @Test
    public void testNoReaderBehaviour2() throws IOException {
        try (PipedOutputStream pos = new PipedOutputStream(1024);){
            try (InputStream is = pos.getInputStream();){
                pos.write(123);
                pos.flush();
                int val = is.read();
                Assert.assertEquals((long)123L, (long)val);
            }
            pos.write(123);
        }
    }

    @Test(timeout=2000L, expected=IOTimeoutException.class)
    public void testNoReaderTimeout() throws IOException {
        try (ExecutionContext ctx = ExecutionContexts.start((String)"tt", (long)1L, (TimeUnit)TimeUnit.MILLISECONDS);
             PipedOutputStream pos = new PipedOutputStream(10);
             InputStream is = pos.getInputStream();){
            for (int i = 0; i < 11; ++i) {
                pos.write(123);
            }
        }
    }

    @Test
    public void testCloseWithReason() throws IOException {
        try (PipedOutputStream pos = new PipedOutputStream(10);){
            pos.write(123);
            IOException ex = new IOException();
            pos.close((Exception)ex);
            try {
                pos.write(123);
                Assert.fail();
            }
            catch (IOException ex2) {
                Assert.assertEquals((Object)ex, (Object)ex2.getCause());
            }
            try (InputStream is = pos.getInputStream();){
                Assert.assertEquals((long)123L, (long)is.read());
            }
        }
    }
}

