/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.io.AppendableOutputStream;
import org.spf4j.io.WriterOutputStream;

@SuppressFBWarnings(value={"PREDICTABLE_RANDOM"})
public class WriterOutputStreamTest {
    private static final String TEST_STRING = "\u00e0 peine arriv\u00e9s nous entr\u00e2mes dans sa chambre";
    private static final String LARGE_TEST_STRING;

    private void assertTestWithSingleByteWrite(String testString, String charsetName) throws IOException {
        byte[] bytes = testString.getBytes(charsetName);
        StringWriter writer = new StringWriter();
        WriterOutputStream out = new WriterOutputStream((Writer)writer, charsetName);
        for (byte b : bytes) {
            out.write((int)b);
        }
        out.close();
        Assert.assertEquals((Object)testString, (Object)writer.toString());
    }

    private void assertTestWithBufferedWrite(String testString, String charsetName) throws IOException {
        int length;
        byte[] expected = testString.getBytes(charsetName);
        StringWriter writer = new StringWriter();
        WriterOutputStream out = new WriterOutputStream((Writer)writer, charsetName);
        ThreadLocalRandom rnd = ThreadLocalRandom.current();
        for (int offset = 0; offset < expected.length; offset += length) {
            length = Math.min(Math.abs(rnd.nextInt() % 128), expected.length - offset);
            out.write(expected, offset, length);
        }
        out.close();
        Assert.assertEquals((Object)testString, (Object)writer.toString());
    }

    @Test
    public void testUTF8WithSingleByteWrite() throws IOException {
        this.assertTestWithSingleByteWrite(TEST_STRING, "UTF-8");
    }

    @Test
    public void testLargeUTF8WithSingleByteWrite() throws IOException {
        this.assertTestWithSingleByteWrite(LARGE_TEST_STRING, "UTF-8");
    }

    @Test
    public void testUTF8WithBufferedWrite() throws IOException {
        this.assertTestWithBufferedWrite(TEST_STRING, "UTF-8");
    }

    @Test
    public void testLargeUTF8WithBufferedWrite() throws IOException {
        this.assertTestWithBufferedWrite(LARGE_TEST_STRING, "UTF-8");
    }

    @Test
    public void testUTF16WithSingleByteWrite() throws IOException {
        block2: {
            try {
                this.assertTestWithSingleByteWrite(TEST_STRING, "UTF-16");
            }
            catch (UnsupportedOperationException e) {
                if (System.getProperty("java.vendor").contains("IBM")) break block2;
                Assert.fail((String)"This test should only throw UOE on IBM JDKs with broken UTF-16");
            }
        }
    }

    @Test
    public void testUTF16WithBufferedWrite() throws IOException {
        block2: {
            try {
                this.assertTestWithBufferedWrite(TEST_STRING, "UTF-16");
            }
            catch (UnsupportedOperationException e) {
                if (System.getProperty("java.vendor").contains("IBM")) break block2;
                Assert.fail((String)"This test should only throw UOE on IBM JDKs with broken UTF-16");
            }
        }
    }

    @Test
    public void testUTF16BEWithSingleByteWrite() throws IOException {
        this.assertTestWithSingleByteWrite(TEST_STRING, "UTF-16BE");
    }

    @Test
    public void testUTF16BEWithBufferedWrite() throws IOException {
        this.assertTestWithBufferedWrite(TEST_STRING, "UTF-16BE");
    }

    @Test
    public void testUTF16LEWithSingleByteWrite() throws IOException {
        this.assertTestWithSingleByteWrite(TEST_STRING, "UTF-16LE");
    }

    @Test
    public void testUTF16LEWithBufferedWrite() throws IOException {
        this.assertTestWithBufferedWrite(TEST_STRING, "UTF-16LE");
    }

    @Test
    public void testFlush() throws IOException {
        StringWriter writer = new StringWriter();
        WriterOutputStream out = new WriterOutputStream((Writer)writer, "us-ascii", 1024);
        out.write("abc".getBytes(StandardCharsets.US_ASCII));
        Assert.assertEquals((long)0L, (long)writer.getBuffer().length());
        out.flush();
        Assert.assertEquals((Object)"abc", (Object)writer.toString());
        out.close();
    }

    @Test
    public void testFlush2() throws IOException {
        StringWriter writer = new StringWriter();
        AppendableOutputStream out = new AppendableOutputStream((Appendable)writer, "us-ascii", 1024);
        out.write("abc".getBytes(StandardCharsets.US_ASCII));
        Assert.assertEquals((long)0L, (long)writer.getBuffer().length());
        out.flush();
        Assert.assertEquals((Object)"abc", (Object)writer.toString());
        out.close();
    }

    static {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            buffer.append(TEST_STRING);
        }
        LARGE_TEST_STRING = buffer.toString();
    }
}

