/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io.proxy;

import com.google.common.base.Charsets;
import com.google.common.net.HostAndPort;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.AbstractRunnable;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.ds.UpdateablePriorityQueue;
import org.spf4j.io.Streams;
import org.spf4j.io.tcp.ClientHandler;
import org.spf4j.io.tcp.DeadlineAction;
import org.spf4j.io.tcp.TcpServer;
import org.spf4j.io.tcp.proxy.ProxyClientHandler;
import org.spf4j.io.tcp.proxy.Sniffer;
import org.spf4j.io.tcp.proxy.SnifferFactory;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON", "MDM_THREAD_YIELD"})
public class TcpServerTest {
    private static final Logger LOG = LoggerFactory.getLogger(TcpServerTest.class);
    private static final Logger SNIFFER_LOG = LoggerFactory.getLogger((String)(TcpServerTest.class + ".SNIFFER"));
    private static final String TEST_SITE = "localhost";
    private static final int TEST_PORT = 8080;
    private static HttpServer server;
    private SnifferFactory printSnifferFactory = new SnifferFactory(){

        public Sniffer get(SocketChannel channel) {
            return new Sniffer(){
                private final CharsetDecoder asciiDecoder = Charsets.US_ASCII.newDecoder();

                public int received(ByteBuffer data, int nrBytes) {
                    if (nrBytes < 0) {
                        SNIFFER_LOG.debug("EOF");
                        return nrBytes;
                    }
                    ByteBuffer duplicate = data.duplicate();
                    duplicate.position(data.position() - nrBytes);
                    duplicate = duplicate.slice();
                    duplicate.position(nrBytes);
                    duplicate.flip();
                    CharBuffer cb = CharBuffer.allocate((int)(this.asciiDecoder.maxCharsPerByte() * (float)duplicate.limit()));
                    this.asciiDecoder.decode(duplicate, cb, true);
                    cb.flip();
                    SNIFFER_LOG.debug(cb.toString());
                    return nrBytes;
                }
            };
        }
    };

    @BeforeClass
    public static void createHttpServer() throws IOException {
        server = HttpServer.create(new InetSocketAddress(8080), 0);
        server.createContext("/", new HttpHandler(){

            @Override
            public void handle(HttpExchange he) throws IOException {
                Headers respHeaders = he.getResponseHeaders();
                respHeaders.add("testheader", "testValue");
                he.sendResponseHeaders(200, 0L);
                OutputStream responseBody = he.getResponseBody();
                responseBody.write("Some Body".getBytes(StandardCharsets.UTF_8));
                responseBody.close();
            }
        });
        server.start();
    }

    public static void stopHttpServer() {
        server.stop(3);
    }

    @Test(timeout=100000L)
    public void testProxy() throws IOException, InterruptedException {
        ForkJoinPool pool = new ForkJoinPool(1024);
        try (TcpServer server = new TcpServer((ExecutorService)pool, (ClientHandler)new ProxyClientHandler(HostAndPort.fromParts((String)TEST_SITE, (int)8080), this.printSnifferFactory, this.printSnifferFactory, 10000, 5000), 1976, 10);){
            server.startAsync().awaitRunning();
            long start = System.currentTimeMillis();
            byte[] originalContent = TcpServerTest.readfromSite("http://localhost:8080");
            long time1 = System.currentTimeMillis();
            byte[] proxiedContent = TcpServerTest.readfromSite("http://localhost:1976");
            long time2 = System.currentTimeMillis();
            LOG.debug("Direct = {}  ms, proxied = {}", (Object)(time1 - start), (Object)(time2 - time1));
            Assert.assertArrayEquals((byte[])originalContent, (byte[])proxiedContent);
        }
    }

    @Test(timeout=100000L)
    public void testProxySimple() throws IOException, InterruptedException {
        ForkJoinPool pool = new ForkJoinPool(1024);
        try (TcpServer server = new TcpServer((ExecutorService)pool, (ClientHandler)new ProxyClientHandler(HostAndPort.fromParts((String)TEST_SITE, (int)8080), this.printSnifferFactory, this.printSnifferFactory, 10000, 5000), 1977, 10);){
            server.startAsync().awaitRunning();
            byte[] proxiedContent = TcpServerTest.readfromSite("http://localhost:1977");
            Assert.assertNotNull((Object)proxiedContent);
        }
    }

    @Test(expected=SocketException.class, timeout=60000L)
    public void testTimeout() throws IOException, InterruptedException {
        String testSite = "10.10.10.10";
        ForkJoinPool pool = new ForkJoinPool(1024);
        try (TcpServer server = new TcpServer((ExecutorService)pool, (ClientHandler)new ProxyClientHandler(HostAndPort.fromParts((String)testSite, (int)80), null, null, 10000, 5000), 1978, 10);){
            server.startAsync().awaitRunning();
            TcpServerTest.readfromSite("http://localhost:1978");
            Assert.fail((String)"Should timeout");
        }
    }

    @Test(timeout=100000L)
    public void testRestart() throws IOException, InterruptedException, TimeoutException {
        ForkJoinPool pool = new ForkJoinPool(1024);
        try (TcpServer server = new TcpServer((ExecutorService)pool, (ClientHandler)new ProxyClientHandler(HostAndPort.fromParts((String)"bla", (int)80), null, null, 10000, 5000), 1979, 10);){
            server.startAsync().awaitRunning(10L, TimeUnit.SECONDS);
            server.stopAsync().awaitTerminated(10L, TimeUnit.SECONDS);
            server.startAsync().awaitRunning(60L, TimeUnit.SECONDS);
            Assert.assertTrue((boolean)server.isRunning());
        }
    }

    @Test(expected=IOException.class, timeout=10000L)
    public void testRejectingServer() throws IOException, InterruptedException {
        String testSite = TEST_SITE;
        ForkJoinPool pool = new ForkJoinPool(1024);
        try (TcpServer rejServer = new TcpServer((ExecutorService)pool, new ClientHandler(){

            public void handle(Selector serverSelector, SocketChannel clientChannel, ExecutorService exec, BlockingQueue<Runnable> tasksToRunBySelector, UpdateablePriorityQueue<DeadlineAction> deadlineActions) throws IOException {
                clientChannel.configureBlocking(true);
                ByteBuffer allocate = ByteBuffer.allocate(1024);
                clientChannel.read(allocate);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    throw new RuntimeException(ex);
                }
                allocate.flip();
                clientChannel.write(allocate);
                clientChannel.close();
            }
        }, 1980, 10);){
            rejServer.startAsync().awaitRunning();
            try (TcpServer server = new TcpServer((ExecutorService)pool, (ClientHandler)new ProxyClientHandler(HostAndPort.fromParts((String)testSite, (int)1980), null, null, 10000, 5000), 1981, 10);){
                server.startAsync().awaitRunning();
                byte[] readfromSite = TcpServerTest.readfromSite("http://localhost:1981");
                LOG.debug("Response: {}", (Object)new String(readfromSite, StandardCharsets.UTF_8));
            }
        }
    }

    @Test(expected=SocketException.class, timeout=10000L)
    public void testKill() throws IOException, InterruptedException {
        String testSite = "10.10.10.10";
        ForkJoinPool pool = new ForkJoinPool(1024);
        try (final TcpServer server = new TcpServer((ExecutorService)pool, (ClientHandler)new ProxyClientHandler(HostAndPort.fromParts((String)testSite, (int)80), null, null, 10000, 10000), 1982, 10);){
            server.startAsync().awaitRunning();
            DefaultScheduler.INSTANCE.schedule((Runnable)new AbstractRunnable(true){

                public void doRun() throws IOException {
                    server.close();
                }
            }, 2L, TimeUnit.SECONDS);
            TcpServerTest.readfromSite("http://localhost:1982");
            Assert.fail((String)"Should timeout");
        }
    }

    private static byte[] readfromSite(String siteUrl) throws IOException {
        URL url = new URL(siteUrl);
        URLConnection conn = url.openConnection();
        conn.setConnectTimeout(10000);
        conn.setReadTimeout(30000);
        InputStream stream = conn.getInputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        Streams.copy((InputStream)stream, (OutputStream)bos);
        return bos.toByteArray();
    }
}

