/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.ssdump2.Converter;
import org.spf4j.stackmonitor.MonitorTest;
import org.spf4j.stackmonitor.ProfiledExecutionContextFactory;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.Sampler;
import org.spf4j.stackmonitor.ThreadStackSampler;
import org.spf4j.stackmonitor.TracingExecutionContextStackCollector;

public final class SsdumpTest {
    private static final Logger LOG;

    @Test
    public void testDumpExecContexts() throws InterruptedException, IOException {
        ProfiledExecutionContextFactory contextFactory = (ProfiledExecutionContextFactory)ExecutionContexts.getContextFactory();
        Sampler sampler = new Sampler(1, t -> new ThreadStackSampler(() -> ((ProfiledExecutionContextFactory)contextFactory).getCurrentThreads()));
        Map<String, SampleNode> collected = this.sampleTest(sampler, "ecStackSample");
        Assert.assertEquals((String)("Actual: " + collected), (long)1L, (long)collected.size());
    }

    @Test
    public void testTracingDumpExecContexts() throws InterruptedException, IOException {
        ProfiledExecutionContextFactory contextFactory = (ProfiledExecutionContextFactory)ExecutionContexts.getContextFactory();
        Sampler sampler = new Sampler(1, t -> new TracingExecutionContextStackCollector(() -> ((ProfiledExecutionContextFactory)contextFactory).getCurrentThreadContexts()));
        Map<String, SampleNode> collected = this.sampleTest(sampler, "ecTracingStackSample");
        Assert.assertThat(collected.keySet(), (Matcher)Matchers.hasItems((Matcher[])new Matcher[]{Matchers.equalTo((Object)"testThread"), Matchers.containsString((String)"org.spf4j.stackmonitor.SsdumpTest")}));
    }

    @Test
    public void testDumpDefault() throws InterruptedException, IOException {
        Sampler sampler = new Sampler(1);
        this.sampleTest(sampler, "stackSample");
    }

    public Map<String, SampleNode> sampleTest(Sampler sampler, String filename) throws InterruptedException, IOException {
        sampler.registerJmx();
        sampler.start();
        MonitorTest.main(new String[0]);
        File serializedFile = File.createTempFile(filename, ".ssdump3");
        Map collected = sampler.getStackCollectionsAndReset();
        Converter.saveLabeledDumps((File)serializedFile, (Map)collected);
        LOG.debug("Dumped to file {}", (Object)serializedFile);
        sampler.stop();
        Map loadedDumps = Converter.loadLabeledDumps((File)serializedFile);
        for (Map.Entry entry : loadedDumps.entrySet()) {
            LOG.debug("Loaded {}", entry.getKey());
        }
        return collected;
    }

    static {
        System.setProperty("spf4j.execContentFactoryWrapperClass", "org.spf4j.stackmonitor.ProfiledExecutionContextFactory");
        LOG = LoggerFactory.getLogger(SsdumpTest.class);
    }
}

