/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.unix;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.unix.CLibrary;
import sun.misc.Signal;

@SuppressFBWarnings(value={"IICU_INCORRECT_INTERNAL_CLASS_USE"})
public class CLibraryTest {
    private static final Logger LOG = LoggerFactory.getLogger(CLibraryTest.class);

    @Test
    public void testStrSignal() {
        String strsignal = CLibrary.INSTANCE.strsignal(9);
        Assert.assertThat((Object)strsignal, (Matcher)Matchers.startsWith((String)"Kill"));
    }

    @Test
    public void testSignal() throws IOException, InterruptedException, ExecutionException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(1);
        Signal.handle(new Signal("USR2"), signal -> {
            LOG.debug("Received signal: {}", (Object)signal);
            latch.countDown();
        });
        Runtime.jrunAndLog(CLibraryTest.class, (long)60000L, (String[])new String[0]);
        Assert.assertTrue((boolean)latch.await(1L, TimeUnit.MINUTES));
    }

    public static void main(String[] args) {
        int ppid = CLibrary.INSTANCE.getppid();
        Signal signal = new Signal("USR2");
        LOG.info("Sending signal: {}", (Object)signal);
        CLibrary.INSTANCE.kill(ppid, signal.getNumber());
    }
}

