/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.base.CharSequences;
import org.spf4j.base.JavaUtils;

@SuppressFBWarnings(value={"LSC_LITERAL_STRING_COMPARISON"})
public class CharSequencesTest {
    @Test
    public void testLineNumbering() {
        CharSequence lineNumbered = CharSequences.toLineNumbered((int)0, (CharSequence)"a\nbla\nc");
        Assert.assertEquals((Object)"/* 0 */ a\n/* 1 */ bla\n/* 2 */ c", (Object)lineNumbered.toString());
    }

    @Test
    public void testID() {
        Assert.assertFalse((boolean)JavaUtils.isJavaIdentifier((CharSequence)""));
        Assert.assertFalse((boolean)JavaUtils.isJavaIdentifier(null));
        Assert.assertFalse((boolean)JavaUtils.isJavaIdentifier((CharSequence)"12A"));
        Assert.assertTrue((boolean)JavaUtils.isJavaIdentifier((CharSequence)"_a"));
        Assert.assertTrue((boolean)JavaUtils.isJavaIdentifier((CharSequence)"a"));
        Assert.assertTrue((boolean)JavaUtils.isJavaIdentifier((CharSequence)"a123FGH"));
    }

    @Test
    public void testCompare() {
        Assert.assertEquals((long)0L, (long)CharSequences.compare((CharSequence)"blabla", (int)6, (CharSequence)"blabla/cucu", (int)6));
    }

    @Test
    public void testCompare2() {
        Assert.assertEquals((long)0L, (long)CharSequences.compare((CharSequence)"cacablabla", (int)4, (int)6, (CharSequence)"ablabla/cucu", (int)1, (int)6));
    }

    @Test
    public void testCompare3() {
        Assert.assertEquals((long)"blabla123".compareTo("blabla"), (long)CharSequences.compare((CharSequence)"cacablabla123", (int)4, (int)9, (CharSequence)"ablabla/cucu", (int)1, (int)6));
    }

    @Test
    public void testCompare4() {
        Assert.assertEquals((long)"bla".compareTo("lab"), (long)CharSequences.compare((CharSequence)"cacablabla123", (int)4, (int)3, (CharSequence)"ablabla/cucu", (int)2, (int)3));
    }

    @Test
    public void testCompare5() {
        Assert.assertEquals((long)"bla".compareTo("labl"), (long)CharSequences.compare((CharSequence)"cacablabla123", (int)4, (int)3, (CharSequence)"ablabla/cucu", (int)2, (int)4));
    }

    @Test
    public void testCotains() {
        Assert.assertTrue((boolean)CharSequences.containsIgnoreCase((CharSequence)"asdgafsdHgas", (CharSequence)""));
        Assert.assertTrue((boolean)CharSequences.containsIgnoreCase((CharSequence)"asdgafsdHgas", (CharSequence)"sdh"));
        Assert.assertFalse((boolean)CharSequences.containsIgnoreCase((CharSequence)"asdgafsdHgas", (CharSequence)"sdhf"));
    }

    @Test
    public void testUnsignedIntegerParsing() {
        int val = CharSequences.parseUnsignedInt((CharSequence)"  1234  ", (int)10, (int)2);
        Assert.assertEquals((long)1234L, (long)val);
        val = CharSequences.parseUnsignedInt((CharSequence)"  2147483647  ", (int)10, (int)2);
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)val);
        try {
            CharSequences.parseUnsignedInt((CharSequence)"  21474836471  ", (int)10, (int)2);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testUnsignedLongParsing() {
        long val = CharSequences.parseUnsignedLong((CharSequence)"  1234  ", (int)10, (int)2);
        Assert.assertEquals((long)1234L, (long)val);
        val = CharSequences.parseUnsignedLong((CharSequence)"  9223372036854775807  ", (int)10, (int)2);
        Assert.assertEquals((long)Long.MAX_VALUE, (long)val);
        try {
            CharSequences.parseUnsignedLong((CharSequence)"  92233720368547758071  ", (int)10, (int)2);
            Assert.fail();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    @Test
    public void testOccurenceCount() {
        Assert.assertEquals((long)3L, (long)CharSequences.countIgnoreCase((CharSequence)" aab Aab aaab", (CharSequence)"aab"));
        Assert.assertEquals((long)0L, (long)CharSequences.countIgnoreCase((CharSequence)"", (CharSequence)"aab"));
        Assert.assertEquals((long)0L, (long)CharSequences.countIgnoreCase((CharSequence)" ", (CharSequence)"aab"));
        Assert.assertEquals((long)0L, (long)CharSequences.countIgnoreCase((CharSequence)" ", (CharSequence)""));
    }
}

