/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.concurrent.LifoThreadPoolExecutorSQP;
import org.spf4j.perf.cpu.CpuUsageSampler;
import org.spf4j.stackmonitor.Sampler;

@SuppressFBWarnings(value={"MDM_THREAD_YIELD", "PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
public class LifoThreadPoolExecutorInterruptingTest {
    private static final Logger LOG = LoggerFactory.getLogger(LifoThreadPoolExecutorInterruptingTest.class);

    @Test(timeout=60000L)
    public void testLifoExecSQ() throws InterruptedException, IOException, ExecutionException {
        LifoThreadPoolExecutorSQP executor = new LifoThreadPoolExecutorSQP("test", 2, 8, 20, 0);
        File destFolder = new File(Runtime.TMP_FOLDER);
        Sampler s = Sampler.getSampler((int)20, (int)10000, (File)destFolder, (String)"lifeTest1");
        s.start();
        Runtime.gc((long)5000L);
        ArrayBlockingQueue q = new ArrayBlockingQueue(1);
        Future f = executor.submit(() -> {
            q.put(Thread.currentThread());
            return null;
        });
        ((Thread)q.take()).interrupt();
        Assert.assertNull(f.get());
        Thread.sleep(100L);
        long time = CpuUsageSampler.getProcessCpuTimeNanos();
        Thread.sleep(3000L);
        long cpuTime = CpuUsageSampler.getProcessCpuTimeNanos() - time;
        File dumpToFile = s.dumpToFile();
        Assert.assertEquals((Object)destFolder.getCanonicalFile(), (Object)dumpToFile.getParentFile().getCanonicalFile());
        LOG.info("Cpu profile saved to {}", (Object)dumpToFile);
        LOG.debug("CPU time = {} ns", (Object)cpuTime);
        s.stop();
        Assert.assertTrue((String)("CPU Time = " + cpuTime), (cpuTime < 1500000000L ? 1 : 0) != 0);
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.SECONDS);
    }

    @Test(timeout=60000L)
    public void testLifoExecSQ2() throws InterruptedException, IOException, ExecutionException {
        LifoThreadPoolExecutorSQP executor = new LifoThreadPoolExecutorSQP("test", 2, 8, 20, 0);
        File destFolder = new File(Runtime.TMP_FOLDER);
        Sampler s = Sampler.getSampler((int)20, (int)10000, (File)destFolder, (String)"lifeTest1");
        s.start();
        Runtime.gc((long)5000L);
        List running = executor.shutdownNow();
        Assert.assertTrue((boolean)running.isEmpty());
        Thread.sleep(100L);
        long time = CpuUsageSampler.getProcessCpuTimeNanos();
        Thread.sleep(3000L);
        long cpuTime = CpuUsageSampler.getProcessCpuTimeNanos() - time;
        File dumpToFile = s.dumpToFile();
        Assert.assertEquals((Object)destFolder.getCanonicalFile(), (Object)dumpToFile.getParentFile().getCanonicalFile());
        LOG.info("Cpu profile saved to {}", (Object)dumpToFile);
        LOG.debug("CPU time = {} ns", (Object)cpuTime);
        s.stop();
        Assert.assertTrue((String)("CPU Time = " + cpuTime), (cpuTime < 1500000000L ? 1 : 0) != 0);
        executor.shutdown();
        executor.awaitTermination(1L, TimeUnit.SECONDS);
    }
}

