/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.TimeSource;
import org.spf4j.failsafe.RateLimiter;
import org.spf4j.log.Level;
import org.spf4j.test.log.annotations.PrintLogs;

public class RateLimiterTest {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimiterTest.class);

    @Test(expected=IllegalArgumentException.class)
    public void testRateLimitInvalid() {
        new RateLimiter(1000.0, 9);
    }

    @Test
    @PrintLogs(ideMinLevel=Level.TRACE)
    public void testRateLimitArgs() {
        try (RateLimiter rateLimiter = new RateLimiter(17.0, 10, 10L, TimeUnit.MILLISECONDS);){
            LOG.debug("Rate Limiter = {}", (Object)rateLimiter);
            Assert.assertEquals((double)1.0, (double)rateLimiter.getPermitsPerReplenishInterval(), (double)0.001);
        }
        rateLimiter = new RateLimiter(1.0E7, 5000000, 500L, TimeUnit.MILLISECONDS);
        var2_2 = null;
        try {
            LOG.debug("Rate Limiter = {}", (Object)rateLimiter);
            Assert.assertEquals((long)500000000L, (long)rateLimiter.getPermitReplenishIntervalNanos());
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (rateLimiter != null) {
                if (var2_2 != null) {
                    try {
                        rateLimiter.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    rateLimiter.close();
                }
            }
        }
    }

    @Test
    public void testRateLimitTryAcquisition() throws InterruptedException {
        try (RateLimiter rateLimiter = new RateLimiter(10.0, 10);){
            LOG.debug("Rate Limiter = {}", (Object)rateLimiter);
            Assert.assertFalse((boolean)rateLimiter.tryAcquire(20, 0L, TimeUnit.MILLISECONDS));
            long startTime = TimeSource.nanoTime();
            boolean tryAcquire = rateLimiter.tryAcquire(20, 2L, TimeUnit.SECONDS);
            LOG.debug("waited {} ns for {}", (Object)(TimeSource.nanoTime() - startTime), (Object)rateLimiter);
            Assert.assertTrue((boolean)tryAcquire);
            Assert.assertFalse((boolean)rateLimiter.tryAcquire(20, 1L, TimeUnit.SECONDS));
        }
    }

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testRateLimitTryAcquisition2() throws InterruptedException {
        ScheduledExecutorService mockExec = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ScheduledFuture mockFut = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when(mockExec.scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)100000000L), Mockito.eq((long)100000000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))))).thenReturn((Object)mockFut);
        try (RateLimiter rateLimiter = new RateLimiter(10.0, 10, mockExec, () -> 0L);){
            long tryAcquireGetDelayNs = rateLimiter.tryAcquireGetDelayNanos(10, TimeUnit.SECONDS.toNanos(10L));
            LOG.debug("Rate Limiter = {}, waitMs = {}", (Object)rateLimiter, (Object)tryAcquireGetDelayNs);
            Assert.assertEquals((long)900000000L, (long)tryAcquireGetDelayNs);
            Assert.assertEquals((double)-9.0, (double)rateLimiter.getNrPermits(), (double)1.0E-4);
            tryAcquireGetDelayNs = rateLimiter.tryAcquireGetDelayNanos(10, TimeUnit.MILLISECONDS.toNanos(10L));
            Assert.assertTrue((tryAcquireGetDelayNs < 0L ? 1 : 0) != 0);
            tryAcquireGetDelayNs = rateLimiter.tryAcquireGetDelayNanos(1, TimeUnit.MILLISECONDS.toNanos(2000L));
            Assert.assertEquals((long)1000000000L, (long)tryAcquireGetDelayNs);
        }
        ((ScheduledExecutorService)Mockito.verify((Object)mockExec)).scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)100000000L), Mockito.eq((long)100000000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        ((ScheduledFuture)Mockito.verify((Object)mockFut)).cancel(false);
    }

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testRateLimitTryAcquisition3() throws InterruptedException {
        ScheduledExecutorService mockExec = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ScheduledFuture mockFut = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when(mockExec.scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)10000000000L), Mockito.eq((long)10000000000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))))).thenReturn((Object)mockFut);
        try (RateLimiter rateLimiter = new RateLimiter(0.1, 10, mockExec, () -> 0L);){
            long tryAcquireGetDelayNs = rateLimiter.tryAcquireGetDelayNanos(2, TimeUnit.SECONDS.toNanos(10L));
            LOG.debug("Rate Limiter = {}, waitMs = {}", (Object)rateLimiter, (Object)tryAcquireGetDelayNs);
            Assert.assertEquals((long)10000000000L, (long)tryAcquireGetDelayNs);
            Assert.assertEquals((double)-1.0, (double)rateLimiter.getNrPermits(), (double)1.0E-4);
            tryAcquireGetDelayNs = rateLimiter.tryAcquireGetDelayNanos(1, TimeUnit.MILLISECONDS.toNanos(10L));
            Assert.assertTrue((tryAcquireGetDelayNs < 0L ? 1 : 0) != 0);
        }
        ((ScheduledExecutorService)Mockito.verify((Object)mockExec)).scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)10000000000L), Mockito.eq((long)10000000000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        ((ScheduledFuture)Mockito.verify((Object)mockFut)).cancel(false);
    }
}

