/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import com.google.common.base.Throwables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.SocketException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.concurrent.DefaultContextAwareExecutor;
import org.spf4j.concurrent.DefaultScheduler;
import org.spf4j.failsafe.AsyncRetryExecutor;
import org.spf4j.failsafe.DefaultRetryPredicate;
import org.spf4j.failsafe.HedgePolicy;
import org.spf4j.failsafe.Request;
import org.spf4j.failsafe.Response;
import org.spf4j.failsafe.RetryDecision;
import org.spf4j.failsafe.RetryPolicy;
import org.spf4j.failsafe.Server;
import org.spf4j.failsafe.ServerCall;
import org.spf4j.failsafe.concurrent.DefaultFailSafeExecutor;
import org.spf4j.failsafe.concurrent.FailSafeExecutor;
import org.spf4j.failsafe.concurrent.FailSafeExecutorImpl;
import org.spf4j.log.Level;
import org.spf4j.test.log.LogAssert;
import org.spf4j.test.log.TestLogRecord;
import org.spf4j.test.log.TestLoggers;
import org.spf4j.test.matchers.LogMatchers;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
public class RetryPolicyTest {
    public static final String PREDICATE_CLASS = DefaultRetryPredicate.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger(RetryPolicyTest.class);
    private static FailSafeExecutor es;

    @BeforeClass
    public static void init() {
        es = new FailSafeExecutorImpl(DefaultContextAwareExecutor.instance());
    }

    @AfterClass
    public static void shutdown() throws InterruptedException {
        es.close();
    }

    @Test
    public void testNoRetryPolicy() throws IOException, InterruptedException, TimeoutException {
        LogAssert vex = TestLoggers.sys().dontExpect(PREDICATE_CLASS, Level.DEBUG, new Matcher[]{Matchers.any(TestLogRecord.class)});
        try (LogAssert expect = vex;){
            RetryPolicy.noRetryPolicy().run(() -> {
                throw new IOException();
            }, IOException.class);
            Assert.fail();
        }
        catch (IOException ex) {
            vex.assertObservation();
        }
    }

    @Test
    public void testNoRetryPolicyAsync() throws IOException, InterruptedException, TimeoutException {
        LogAssert vex = TestLoggers.sys().dontExpect(PREDICATE_CLASS, Level.DEBUG, new Matcher[]{Matchers.any(TestLogRecord.class)});
        try (LogAssert expect = vex;){
            RetryPolicy.noRetryPolicy().async(HedgePolicy.NONE, (FailSafeExecutor)DefaultFailSafeExecutor.instance()).submit(() -> {
                throw new IOException();
            }).get();
            Assert.fail();
        }
        catch (ExecutionException ex) {
            LOG.debug("Expected exception in testNoRetryPolicyAsync", (Throwable)ex);
            Assert.assertEquals(IOException.class, ex.getCause().getClass());
            vex.assertObservation();
        }
    }

    @Test
    public void testDefaulPolicy() throws IOException, InterruptedException, TimeoutException {
        try (LogAssert expect = TestLoggers.sys().expect(PREDICATE_CLASS, Level.DEBUG, 2, new Matcher[]{LogMatchers.hasMessageWithPattern((String)"Result java.lang.RuntimeException.* retrying org.spf4j.failsafe.RetryPolicyTest.*")});){
            try {
                RetryPolicy.defaultPolicy().run(() -> {
                    throw new RuntimeException();
                }, RuntimeException.class);
                Assert.fail();
            }
            catch (RuntimeException ex) {
                expect.assertObservation();
            }
        }
    }

    @Test
    public void testDefaulPolicyAsync() throws IOException, InterruptedException, TimeoutException {
        try (LogAssert expect = TestLoggers.sys().expect(PREDICATE_CLASS, Level.DEBUG, 2, new Matcher[]{LogMatchers.hasMatchingMessage((Matcher)Matchers.startsWith((String)"Result java.lang.RuntimeException, retrying org.spf4j.failsafe.RetryPolicyTest"))});){
            try {
                RetryPolicy.newBuilder().withDefaultThrowableRetryPredicate().withRetryOnException(Exception.class, 2).buildAsync().submit(() -> {
                    throw new RuntimeException();
                }).get();
                Assert.fail();
            }
            catch (ExecutionException ex) {
                Assert.assertEquals(RuntimeException.class, ex.getCause().getClass());
                expect.assertObservation();
            }
        }
    }

    @Test
    public void testDefaulPolicyInterruption() throws IOException, InterruptedException, TimeoutException {
        try {
            Thread t = Thread.currentThread();
            DefaultScheduler.INSTANCE.schedule(() -> t.interrupt(), 1L, TimeUnit.SECONDS);
            RetryPolicy.newBuilder().withRetryOnException(Exception.class, Integer.MAX_VALUE).build().run(() -> {
                throw new IOException();
            }, IOException.class);
            Assert.fail();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Test
    public void testDefaulPolicyInterruptionAsync() throws IOException, InterruptedException, TimeoutException, ExecutionException {
        Future res = RetryPolicy.newBuilder().withRetryOnException(Exception.class, Integer.MAX_VALUE).buildAsync().submit(() -> {
            throw new IOException();
        });
        try {
            res.get(100L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (TimeoutException timeoutException) {
            // empty catch block
        }
        res.cancel(true);
        Assert.assertTrue((boolean)res.isDone());
        try {
            res.get(100L, TimeUnit.MILLISECONDS);
            Assert.fail();
        }
        catch (CancellationException ex) {
            LOG.debug("exception detail ", (Throwable)ex);
            Assert.assertThat((Object)ex.getSuppressed(), (Matcher)Matchers.arrayWithSize((int)1));
        }
    }

    @Test
    public void testNoRetryPolicy2() throws InterruptedException, TimeoutException {
        RetryPolicy rp = RetryPolicy.newBuilder().build();
        String result = (String)rp.call(() -> "test", RuntimeException.class);
        Assert.assertEquals((Object)"test", (Object)result);
    }

    @Test
    public void testComplexRetrySync() throws InterruptedException, TimeoutException, IOException, ExecutionException {
        AsyncRetryExecutor<Response, ServerCall> rp = this.buildRetryExecutor();
        Server server = new Server();
        Response response1 = new Response(Response.Type.OK, "");
        server.setResponse("url1", x -> response1);
        server.setResponse("url2", r -> new Response(Response.Type.REDIRECT, "url1"));
        server.setResponse("url3", r -> new Response(Response.Type.ERROR, "boooo"));
        this.assertSyncRetry(server, rp, response1);
    }

    @Test
    public void testComplexRetryASync() throws InterruptedException, TimeoutException, IOException, ExecutionException {
        AsyncRetryExecutor<Response, ServerCall> rp = this.buildRetryExecutor();
        Server server = new Server();
        Response response1 = new Response(Response.Type.OK, "");
        server.setResponse("url1", x -> response1);
        server.setResponse("url2", r -> new Response(Response.Type.REDIRECT, "url1"));
        server.setResponse("url3", r -> new Response(Response.Type.ERROR, "boooo"));
        this.assertASyncRetry(server, rp, response1);
    }

    public final AsyncRetryExecutor<Response, ServerCall> buildRetryExecutor() {
        return RetryPolicy.newBuilder().withDefaultThrowableRetryPredicate(Integer.MAX_VALUE).withResultPartialPredicate((resp, sc) -> {
            switch (resp.getType()) {
                case CLIENT_ERROR: {
                    return RetryDecision.abort();
                }
                case REDIRECT: {
                    return RetryDecision.retry((long)0L, (Callable)new ServerCall(sc.getServer(), new Request((String)resp.getPayload(), sc.getRequest().getDeadlineMSEpoch())));
                }
                case RETRY_LATER: {
                    return RetryDecision.retry((long)TimeUnit.NANOSECONDS.convert((Long)resp.getPayload() - System.currentTimeMillis(), TimeUnit.MILLISECONDS), (Callable)sc);
                }
                case TRANSIENT_ERROR: {
                    return RetryDecision.retryDefault((Callable)sc);
                }
                case ERROR: {
                    return null;
                }
                case OK: {
                    return RetryDecision.abort();
                }
            }
            throw new IllegalStateException("Unsupported " + (Object)((Object)resp.getType()));
        }).withResultPartialPredicate((resp, sc) -> resp.getType() == Response.Type.ERROR ? RetryDecision.retryDefault((Callable)sc) : RetryDecision.abort(), 3).buildAsync(es);
    }

    @SuppressFBWarnings(value={"CC_CYCLOMATIC_COMPLEXITY"})
    public final void assertSyncRetry(Server server, AsyncRetryExecutor<Response, ServerCall> rp, Response response1) throws InterruptedException, TimeoutException, ExecutionException, IOException {
        long deadlineMillis = System.currentTimeMillis() + 1000L;
        ServerCall serverCall = new ServerCall(server, new Request("url2", deadlineMillis));
        long timeoutms = deadlineMillis - System.currentTimeMillis();
        LOG.info("Timeout = {}", (Object)timeoutms);
        try (LogAssert retryExpect = TestLoggers.sys().expect(PREDICATE_CLASS, Level.DEBUG, new Matcher[]{LogMatchers.hasMatchingMessage((Matcher)Matchers.startsWith((String)"Result Response{type=REDIRECT, payload=url1}, retrying ServerCall"))});){
            Response resp = (Response)rp.call((Callable)serverCall, SocketException.class, timeoutms, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)response1, (Object)resp);
            retryExpect.assertObservation();
        }
        server.breakException(new SocketException("Bla bla"));
        var10_8 = null;
        try (LogAssert retryExpect2 = TestLoggers.sys().expect(PREDICATE_CLASS, Level.DEBUG, 3, new Matcher[]{LogMatchers.hasMessageWithPattern((String)"Result java.net.SocketException, retrying ServerCall.*")});){
            try {
                rp.run((Callable)new ServerCall(server, new Request("url1", System.currentTimeMillis() + 1000L)), IOException.class, 1000L, TimeUnit.MILLISECONDS);
                Assert.fail();
            }
            catch (TimeoutException ex) {
                LOG.debug("Expected exception", (Throwable)ex);
            }
            retryExpect2.assertObservation();
        }
        catch (Throwable ex) {
            var10_8 = ex;
            throw ex;
        }
        ScheduledFuture<?> submit = DefaultScheduler.INSTANCE.schedule(() -> server.breakException(null), 100L, TimeUnit.MILLISECONDS);
        Response resp = (Response)rp.call((Callable)new ServerCall(server, new Request("url1", System.currentTimeMillis() + 1000L)), IOException.class, 1000L, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)((Object)Response.Type.OK), (Object)((Object)resp.getType()));
        submit.get();
        try (LogAssert retryExpect3 = TestLoggers.sys().expect(PREDICATE_CLASS, Level.DEBUG, 3, new Matcher[]{LogMatchers.hasMessageWithPattern((String)"^Result Response[{]type=ERROR, payload=boooo[}], retrying ServerCall.+ with RETRY.+$")});){
            Response er = (Response)rp.call((Callable)new ServerCall(server, new Request("url3", System.currentTimeMillis() + 1000L)), IOException.class, 1000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)"boooo", (Object)er.getPayload());
            retryExpect3.assertObservation();
        }
        var12_16 = null;
        try (LogAssert retryExpect4 = TestLoggers.sys().expect(PREDICATE_CLASS, Level.DEBUG, 3, new Matcher[]{LogMatchers.hasMessageWithPattern((String)"^Result Response[{]type=ERROR, payload=boooo[}], retrying ServerCall.+ with RETRY.+$")});){
            Response er2 = (Response)rp.call((Callable)new ServerCall(server, new Request("url3", System.currentTimeMillis() + 1000L)), IOException.class, 1000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)"boooo", (Object)er2.getPayload());
            retryExpect4.assertObservation();
        }
        catch (Throwable throwable) {
            var12_16 = throwable;
            throw throwable;
        }
    }

    @SuppressFBWarnings(value={"CC_CYCLOMATIC_COMPLEXITY"})
    public final void assertASyncRetry(Server server, AsyncRetryExecutor<Response, ServerCall> rp, Response response1) throws InterruptedException, TimeoutException, ExecutionException, IOException {
        long deadlineMillis = System.currentTimeMillis() + 1000L;
        Request request = new Request("url2", deadlineMillis);
        ServerCall serverCall = new ServerCall(server, request);
        long timeoutms = request.getDeadlineMSEpoch() - System.currentTimeMillis();
        LOG.info("Timeout = {}", (Object)timeoutms);
        try (LogAssert retryExpect = TestLoggers.sys().expect(PREDICATE_CLASS, Level.DEBUG, new Matcher[]{LogMatchers.hasMatchingMessage((Matcher)Matchers.startsWith((String)"Result Response{type=REDIRECT, payload=url1}, retrying ServerCall"))});){
            Response resp = (Response)rp.submit((Callable)serverCall, timeoutms, TimeUnit.MILLISECONDS).get();
            Assert.assertEquals((Object)response1, (Object)resp);
            retryExpect.assertObservation();
        }
        server.breakException(new SocketException("Bla bla"));
        var11_9 = null;
        try (LogAssert retryExpect2 = TestLoggers.sys().expect(PREDICATE_CLASS, Level.DEBUG, 3, new Matcher[]{LogMatchers.hasMessageWithPattern((String)"Result java.net.SocketException, retrying ServerCall.*")});){
            try {
                rp.submit((Callable)new ServerCall(server, new Request("url1", System.currentTimeMillis() + 1000L)), 1000L, TimeUnit.MILLISECONDS).get(1200L, TimeUnit.MILLISECONDS);
                Assert.fail();
            }
            catch (ExecutionException | TimeoutException ex) {
                LOG.debug("Expected exception", (Throwable)ex);
                Assert.assertEquals(TimeoutException.class, Throwables.getRootCause((Throwable)ex).getClass());
            }
            retryExpect2.assertObservation();
        }
        catch (Throwable throwable) {
            var11_9 = throwable;
            throw throwable;
        }
        ScheduledFuture<?> submit = DefaultScheduler.INSTANCE.schedule(() -> server.breakException(null), 100L, TimeUnit.MILLISECONDS);
        rp.submit((Callable)new ServerCall(server, new Request("url1", System.currentTimeMillis() + 1000L)), 200L, TimeUnit.MILLISECONDS).get();
        submit.get();
        try (LogAssert retryExpect3 = TestLoggers.sys().expect(PREDICATE_CLASS, Level.DEBUG, 3, new Matcher[]{LogMatchers.hasMessageWithPattern((String)"^Result Response[{]type=ERROR, payload=boooo[}], retrying ServerCall.+ with RETRY.+$")});){
            Response er = (Response)rp.submit((Callable)new ServerCall(server, new Request("url3", System.currentTimeMillis() + 1000L)), 1000L, TimeUnit.MILLISECONDS).get(1000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)"boooo", (Object)er.getPayload());
            retryExpect3.assertObservation();
        }
        var12_10 = null;
        try (LogAssert retryExpect4 = TestLoggers.sys().expect(PREDICATE_CLASS, Level.DEBUG, 3, new Matcher[]{LogMatchers.hasMessageWithPattern((String)"^Result Response[{]type=ERROR, payload=boooo[}], retrying ServerCall.+ with RETRY.+$")});){
            Response er2 = (Response)rp.submit((Callable)new ServerCall(server, new Request("url3", System.currentTimeMillis() + 1000L)), 1000L, TimeUnit.MILLISECONDS).get(1000L, TimeUnit.MILLISECONDS);
            Assert.assertEquals((Object)"boooo", (Object)er2.getPayload());
            retryExpect4.assertObservation();
        }
        catch (Throwable throwable) {
            var12_10 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSpecificExceptionRetryPolicy() throws TimeoutException, InterruptedException {
        LogAssert expect = TestLoggers.sys().expect(LOG.getName(), Level.DEBUG, new Matcher[]{LogMatchers.hasFormat((String)"encountered")});
        RetryPolicy policy = RetryPolicy.newBuilder().withExceptionPartialPredicate(IllegalStateException.class, (ex, call) -> {
            LOG.debug("encountered", ex);
            return RetryDecision.abort();
        }).build();
        try {
            policy.run(() -> {
                throw new IllegalStateException();
            }, RuntimeException.class);
            Assert.fail();
        }
        catch (IllegalStateException ex2) {
            expect.assertObservation();
        }
    }
}

