/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.failsafe.Request;
import org.spf4j.failsafe.Response;

public final class Server {
    private static final Logger LOG = LoggerFactory.getLogger(Server.class);
    private final Map<String, Function<Request, Response>> responses = new HashMap<String, Function<Request, Response>>();
    private volatile Exception breakException;

    public void breakException(Exception ex) {
        LOG.info("Setting break exception", (Object)(ex == null ? null : ex.toString()));
        this.breakException = ex;
    }

    public void setResponse(String url, Function<Request, Response> response) {
        this.responses.put(url, response);
    }

    public Response execute(Request request) throws Exception {
        Exception be = this.breakException;
        if (be != null) {
            LOG.debug("broken, throwing exception");
            throw be;
        }
        long deadlineMSEpoch = request.getDeadlineMSEpoch();
        long timeout = deadlineMSEpoch - System.currentTimeMillis();
        if (timeout < 0L) {
            LOG.debug("Response complete with timeout {}", (Object)timeout);
            return new Response(Response.Type.TRANSIENT_ERROR, timeout);
        }
        Response resp = this.responses.get(request.getUrl()).apply(request);
        if (resp == null) {
            resp = new Response(Response.Type.CLIENT_ERROR, null);
        }
        LOG.debug("Response complete {}", (Object)resp);
        return resp;
    }

    public String toString() {
        return "Server{responses=" + this.responses + ", breakException=" + this.breakException + '}';
    }
}

