/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.CharSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.io.Csv;
import org.spf4j.io.PushbackReader;
import org.spf4j.io.csv.CsvParseException;
import org.spf4j.io.csv.CsvReader;
import org.spf4j.io.csv.CsvRuntimeException;
import org.spf4j.io.csv.UncheckedCsvParseException;

@SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
public final class CsvTest {
    private static final Logger LOG = LoggerFactory.getLogger(CsvTest.class);

    @Test
    public void testCsvReadWrite() throws IOException, CsvParseException {
        File testFile = this.createTestCsv();
        List data = (List)Csv.read((File)testFile, (Charset)StandardCharsets.UTF_8, (Csv.CsvHandler)new Csv.CsvHandler<List<Map<String, String>>>(){
            private boolean firstRow = true;
            private final List<Map<String, String>> result = new ArrayList<Map<String, String>>();
            private List<String> header = new ArrayList<String>();
            private Map<String, String> row = null;
            private int i = 0;

            public void startRow() {
                if (!this.firstRow) {
                    this.row = Maps.newHashMapWithExpectedSize((int)this.header.size());
                    this.i = 0;
                }
            }

            public void element(CharSequence elem) {
                if (this.firstRow) {
                    this.header.add(elem.toString());
                } else {
                    this.row.put(this.header.get(this.i++), elem.toString());
                }
            }

            public void endRow() {
                if (this.firstRow) {
                    this.firstRow = false;
                } else {
                    this.result.add(this.row);
                }
            }

            public List<Map<String, String>> eof() {
                return this.result;
            }
        });
        Map d0 = (Map)data.get(0);
        Assert.assertEquals((Object)"1,3", d0.get("c"));
        Assert.assertEquals((Object)"1", d0.get("d"));
        Map d1 = (Map)data.get(1);
        Assert.assertEquals((Object)"1,3", d1.get("d"));
        Assert.assertEquals((Object)"\"", d1.get("b"));
        Assert.assertEquals((Object)"0\n", d1.get("c"));
    }

    @Test(expected=CsvParseException.class)
    public void testCsvReadWriteException() throws IOException, CsvParseException {
        File testFile = this.createTestCsv();
        Csv.read((File)testFile, (Charset)StandardCharsets.UTF_8, (Csv.CsvHandler)new Csv.CsvHandler<Void>(){

            public void element(CharSequence elem) throws CsvParseException {
                throw new CsvParseException("Yohooo at " + elem);
            }

            public Void eof() {
                return null;
            }
        });
    }

    @Test(expected=CsvRuntimeException.class)
    public void testCsvReadWriteException2() throws IOException, CsvParseException {
        File testFile = this.createTestCsv();
        Csv.read((File)testFile, (Charset)StandardCharsets.UTF_8, (Csv.CsvHandler)new Csv.CsvHandler<Void>(){

            public void element(CharSequence elem) {
                throw new IllegalArgumentException("Yohooo at " + elem);
            }

            public Void eof() {
                return null;
            }
        });
    }

    @Test
    public void testCsvReadWrite2() throws IOException, CsvParseException {
        File testFile = this.createTestCsv();
        List data = (List)Csv.read((File)testFile, (Charset)StandardCharsets.UTF_8, (Csv.CsvMapHandler)new Csv.CsvMapHandler<List<Map<String, String>>>(){
            private final List<Map<String, String>> result = new ArrayList<Map<String, String>>();

            public void row(Map<String, String> row) {
                this.result.add(row);
            }

            public List<Map<String, String>> eof() {
                return this.result;
            }
        });
        Map d0 = (Map)data.get(0);
        Assert.assertEquals((Object)"1,3", d0.get("c"));
        Assert.assertEquals((Object)"1", d0.get("d"));
        Map d1 = (Map)data.get(1);
        Assert.assertEquals((Object)"1,3", d1.get("d"));
        Assert.assertEquals((Object)"\"", d1.get("b"));
        Assert.assertEquals((Object)"0\n", d1.get("c"));
    }

    private File createTestCsv() throws IOException {
        File testFile = File.createTempFile("csvTest", ".csv");
        LOG.debug("test file : {}", (Object)testFile);
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(testFile.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            Csv.writeCsvRow((Appendable)writer, (Object[])new Object[]{"a", "b", "c", "d"});
            Csv.writeCsvRow((Appendable)writer, (Object[])new Object[]{"1.2\r", "1", "1,3", 1});
            Csv.writeCsvRow((Appendable)writer, (Object[])new Object[]{"0", "\"", "0\n", "1,3"});
        }
        LOG.debug("test file written {}", (Object)testFile);
        return testFile;
    }

    @Test
    public void testReadRow() throws IOException, CsvParseException {
        List row = Csv.readRow((Reader)new StringReader("a,b,\",c\",d"));
        Assert.assertEquals((Object)"a", row.get(0));
    }

    public static void main(String[] params) throws IOException, CsvParseException {
        CsvTest test = new CsvTest();
        for (int i = 0; i < 10; ++i) {
            test.testLargeFileRead();
        }
    }

    @Test
    @Ignore
    public void testLargeFileRead() throws IOException, CsvParseException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new GZIPInputStream(new URL("http://www.maxmind.com/download/worldcities/worldcitiespop.txt.gz").openStream()), StandardCharsets.UTF_8), 65536);){
            long startTime = System.currentTimeMillis();
            long count = (Long)Csv.read((Reader)reader, (Csv.CsvHandler)new Csv.CsvHandler<Long>(){
                private long count = 0L;

                public void element(CharSequence elem) {
                }

                public void endRow() {
                    ++this.count;
                }

                public Long eof() {
                    return this.count;
                }
            });
            LOG.debug("Line count is {} in {}", (Object)count, (Object)(System.currentTimeMillis() - startTime));
            Assert.assertEquals((long)3173959L, (long)count);
        }
    }

    @Test
    public void testCsvRowParsing() throws IOException, CsvParseException {
        List readRow = Csv.readRow((Reader)new StringReader(""));
        Assert.assertEquals(Collections.singletonList(""), (Object)readRow);
    }

    @Test
    public void testCsvRowParsing2() throws IOException, CsvParseException {
        List readRow = Csv.readRow((Reader)CharSource.wrap((CharSequence)"").openStream());
        Assert.assertEquals(Collections.singletonList(""), (Object)readRow);
    }

    @Test
    public void testCsvStream1() throws IOException, CsvParseException {
        CsvReader reader = Csv.readerNoBOM((PushbackReader)new PushbackReader((Reader)new StringReader("")));
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testCsvStream1n1() throws IOException, CsvParseException {
        CsvReader reader = Csv.readerNoBOM((PushbackReader)new PushbackReader((Reader)new StringReader(",")));
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testCsvStream2() throws IOException, CsvParseException {
        CsvReader reader = Csv.readerNoBOM((PushbackReader)new PushbackReader((Reader)new StringReader("bla")));
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"bla", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testCsvStream3() throws IOException, CsvParseException {
        CsvReader reader = Csv.readerNoBOM((PushbackReader)new PushbackReader((Reader)new StringReader("\"bla\"")));
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"bla", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testCsvStream4() throws IOException, CsvParseException {
        CsvReader reader = Csv.readerNoBOM((PushbackReader)new PushbackReader((Reader)new StringReader("bla,\"bla\"\n")));
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"bla", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"bla", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testCsvStream5() throws IOException, CsvParseException {
        CsvReader reader = Csv.reader((Reader)new StringReader("bla,\"bla\"\nuhu,uhu2\n"));
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"bla", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"bla", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"uhu", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"uhu2", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_ROW, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.ELEMENT, (Object)reader.next());
        Assert.assertEquals((Object)"", (Object)reader.getElement().toString());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
        Assert.assertEquals((Object)CsvReader.TokenType.END_DOCUMENT, (Object)reader.next());
    }

    @Test
    public void testLineIteration() {
        int nr = 0;
        for (Iterable line : Csv.asIterable((Reader)new StringReader("bla,\"bla\"\nuhu,uhu2\n"))) {
            LOG.debug("{}", (Object)line);
            ++nr;
        }
        Assert.assertEquals((long)3L, (long)nr);
    }

    @Test(expected=UncheckedCsvParseException.class)
    public void testLineIterationError() {
        for (Iterable line : Csv.asIterable((Reader)new StringReader("bla,\"bla"))) {
            LOG.debug("{}", (Object)line);
        }
        Assert.fail();
    }

    @Test
    public void testCsvFileParsing() throws IOException, CsvParseException {
        try (InputStream resourceAsStream = CsvTest.class.getResourceAsStream("/test.csv");){
            int nr = (Integer)Csv.read((Reader)new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8), (Csv.CsvMapHandler)new Csv.CsvMapHandler<Integer>(){
                private int i = 0;

                public void row(Map<String, String> row) {
                    LOG.debug("Row {}", row);
                    ++this.i;
                }

                public Integer eof() {
                    return this.i;
                }
            });
            Assert.assertEquals((long)3L, (long)nr);
        }
    }

    @Test
    public void testCsvFileParsing2() throws IOException {
        try (InputStream resourceAsStream = CsvTest.class.getResourceAsStream("/test.csv");){
            Iterable asIterable = Csv.asIterable((Reader)new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8));
            int i = 0;
            ArrayList lastRow = null;
            for (Iterable row : asIterable) {
                lastRow = Lists.newArrayList((Iterable)row);
                LOG.debug("row {}", (Object)row);
                ++i;
            }
            Assert.assertEquals((long)4L, (long)i);
            Assert.assertEquals((Object)"3,,\nasdg,,ahsd\nsdf", lastRow.get(0));
        }
    }

    @Test(expected=CsvParseException.class)
    public void testCsvFileParsingBad() throws IOException, CsvParseException {
        try (InputStream resourceAsStream = CsvTest.class.getResourceAsStream("/test_bad.csv");){
            Csv.read((Reader)new InputStreamReader(resourceAsStream, StandardCharsets.UTF_8), (Csv.CsvMapHandler)new Csv.CsvMapHandler<Void>(){

                public void row(Map<String, String> row) {
                    LOG.debug("Row {}", row);
                }

                public Void eof() {
                    return null;
                }
            });
        }
    }
}

