/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.io;

import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.ThreadLocalRandom;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Strings;
import org.spf4j.io.MemorizingBufferedInputStream;
import org.spf4j.io.PipedOutputStreamTest;
import org.spf4j.io.PushbackInputStreamEx;
import org.spf4j.recyclable.impl.ArraySuppliers;

public class MemorizingBufferedInputStreamTest {
    private static final Logger LOG = LoggerFactory.getLogger(MemorizingBufferedInputStreamTest.class);
    private static final String TSTR = "This is a super \u00ef cool, mega dupper test string for testing piping..........E";

    @Test
    @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON", "RV_RETURN_VALUE_IGNORED"})
    public void testBuffering() throws IOException {
        byte[] bytes = new byte[16384];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)(97 + i % 10);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bytes){
            private boolean first;
            {
                this.first = true;
            }

            @Override
            public synchronized int read(byte[] b, int off, int len) {
                if (this.first && len > 260) {
                    this.first = false;
                    return super.read(b, off, 260);
                }
                return super.read(b, off, len);
            }
        };
        try (MemorizingBufferedInputStream mbis = new MemorizingBufferedInputStream((InputStream)bis);){
            StringBuilder sb = new StringBuilder();
            PushbackInputStreamEx pushbackInputStreamEx = new PushbackInputStreamEx((InputStream)mbis);
            int read = pushbackInputStreamEx.read();
            pushbackInputStreamEx.unread(read);
            CharStreams.copy((Readable)new InputStreamReader((InputStream)pushbackInputStreamEx, StandardCharsets.UTF_8), (Appendable)sb);
            Assert.assertEquals((long)16384L, (long)sb.length());
            Assert.assertEquals((Object)new String(bytes, StandardCharsets.US_ASCII), (Object)sb.toString());
        }
    }

    @Test
    public void testSimpleStreamBuffering() throws IOException {
        int val;
        byte[] array = Strings.toUtf8((String)TSTR);
        ByteArrayInputStream bis = new ByteArrayInputStream(array);
        MemorizingBufferedInputStream mis = new MemorizingBufferedInputStream((InputStream)bis);
        int i = 0;
        while ((val = mis.read()) > 0) {
            System.out.print((char)val);
            Assert.assertEquals((long)array[i], (long)((byte)val));
            ++i;
        }
        Assert.assertEquals((long)i, (long)array.length);
    }

    @Test
    public void testStreamCLose() throws IOException {
        byte[] array = Strings.toUtf8((String)TSTR);
        ByteArrayInputStream bis = new ByteArrayInputStream(array);
        MemorizingBufferedInputStream mis = new MemorizingBufferedInputStream((InputStream)bis, 8);
        for (int i = 0; i < 6; ++i) {
            int val = mis.read();
            LOG.debug("Read char '{}'", (Object)Character.valueOf((char)val));
            Assert.assertEquals((long)array[i], (long)((byte)val));
        }
        LOG.debug("MIS before close {}", (Object)mis);
        mis.close();
        LOG.debug("MIS after close {}", (Object)mis);
    }

    @Test
    public void testSpecialCase() throws IOException {
        PipedOutputStreamTest.test("101", 2, true);
        Assert.assertTrue((boolean)true);
    }

    @Test
    public void testStreamBuffering() throws IOException {
        PipedOutputStreamTest.test(TSTR, 8, true);
        for (int i = 0; i < 100; ++i) {
            ThreadLocalRandom rnd = ThreadLocalRandom.current();
            int nrChars = rnd.nextInt(0, 100000);
            int bufferSize = rnd.nextInt(2, 100000);
            StringBuilder sb = PipedOutputStreamTest.generateTestStr(nrChars);
            PipedOutputStreamTest.test(sb.toString(), bufferSize, true);
            this.testBuff(sb, 8192);
            this.testBuff(sb, 32);
        }
    }

    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    private void testBuff(StringBuilder sb, int buffSize) throws IOException {
        byte[] utf8Bytes = Strings.toUtf8((String)sb.toString());
        ByteArrayInputStream bis = new ByteArrayInputStream(utf8Bytes);
        try (MemorizingBufferedInputStream mbis = new MemorizingBufferedInputStream((InputStream)bis, buffSize, buffSize / 2, ArraySuppliers.Bytes.GL_SUPPLIER, StandardCharsets.UTF_8);){
            int result;
            int val = mbis.read();
            Assert.assertEquals((long)val, (long)mbis.getReadBytesFromBuffer()[0]);
            byte[] buff = new byte[8];
            ByteStreams.readFully((InputStream)mbis, (byte[])buff);
            Assert.assertTrue((boolean)Arrays.equals(buff, Arrays.copyOfRange(mbis.getReadBytesFromBuffer(), 1, 9)));
            while ((result = mbis.read(buff)) >= 0) {
            }
            byte[] unredBytesEnd = mbis.getUnreadBytesFromBuffer();
            Assert.assertEquals((long)0L, (long)unredBytesEnd.length);
            byte[] readBytesFromBuffer = mbis.getReadBytesFromBuffer();
            Assert.assertTrue((boolean)Arrays.equals(readBytesFromBuffer, Arrays.copyOfRange(utf8Bytes, utf8Bytes.length - readBytesFromBuffer.length, utf8Bytes.length)));
        }
    }
}

