/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.perf;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.perf.CloseableMeasurementRecorder;
import org.spf4j.perf.CloseableMeasurementRecorderSource;
import org.spf4j.perf.impl.RecorderFactory;
import org.spf4j.perf.impl.ms.tsdb.TSDBMeasurementStore;
import org.spf4j.tsdb2.TSDBQuery;
import org.spf4j.tsdb2.TSDBWriter;
import org.spf4j.tsdb2.TimeSeries;
import org.spf4j.tsdb2.avro.TableDef;

@SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
public final class RecorderFactoryTest {
    @Test
    public void testCreateScalableQuantizedRecorder() throws IOException, InterruptedException {
        String forWhat = "test1";
        String unitOfMeasurement = "ms";
        int sampleTime = 1000;
        int factor = 10;
        int lowerMagnitude = 0;
        int higherMagnitude = 3;
        int quantasPerMagnitude = 10;
        CloseableMeasurementRecorder result = RecorderFactory.createScalableQuantizedRecorder2((Object)forWhat, (String)unitOfMeasurement, (int)sampleTime, (int)factor, (int)lowerMagnitude, (int)higherMagnitude, (int)quantasPerMagnitude);
        for (int i = 0; i < 500; ++i) {
            result.record((long)i);
            Thread.sleep(20L);
        }
        result.close();
        RecorderFactoryTest.assertData(forWhat, 124750L);
    }

    @Test
    public void testCreateScalableQuantizedRecorderSource() throws IOException, InterruptedException {
        String forWhat = "bla";
        String unitOfMeasurement = "ms";
        int sampleTime = 1000;
        int factor = 10;
        int lowerMagnitude = 0;
        int higherMagnitude = 3;
        int quantasPerMagnitude = 10;
        CloseableMeasurementRecorderSource result = RecorderFactory.createScalableQuantizedRecorderSource2((Object)forWhat, (String)unitOfMeasurement, (int)sampleTime, (int)factor, (int)lowerMagnitude, (int)higherMagnitude, (int)quantasPerMagnitude);
        for (int i = 0; i < 5000; ++i) {
            result.getRecorder((Object)("X" + i % 2)).record(1L);
            Thread.sleep(1L);
        }
        result.close();
        RecorderFactoryTest.assertData("bla,X0", 2500L);
    }

    @Test
    public void testOutofQuantizedZoneValues() throws IOException, InterruptedException {
        String forWhat = "largeVals";
        String unitOfMeasurement = "ms";
        int sampleTime = 1000;
        int factor = 10;
        int lowerMagnitude = 0;
        int higherMagnitude = 3;
        int quantasPerMagnitude = 10;
        CloseableMeasurementRecorder result = RecorderFactory.createScalableQuantizedRecorder2((Object)forWhat, (String)unitOfMeasurement, (int)sampleTime, (int)factor, (int)lowerMagnitude, (int)higherMagnitude, (int)quantasPerMagnitude);
        for (int i = 0; i < 500; ++i) {
            result.record(10000L);
            Thread.sleep(20L);
        }
        result.close();
        RecorderFactoryTest.assertData(forWhat, 5000000L);
    }

    @Test
    public void testCreateScalableCountingRecorderSource() throws IOException, InterruptedException {
        String forWhat = "counters";
        String unitOfMeasurement = "counts";
        int sampleTime = 1000;
        CloseableMeasurementRecorderSource result = RecorderFactory.createScalableCountingRecorderSource2((Object)forWhat, (String)unitOfMeasurement, (int)sampleTime);
        for (int i = 0; i < 5000; ++i) {
            result.getRecorder((Object)("X" + i % 2)).record(1L);
            Thread.sleep(1L);
        }
        result.close();
        RecorderFactoryTest.assertData(forWhat + ",X1", 2500L);
    }

    @SuppressFBWarnings(value={"CLI_CONSTANT_LIST_INDEX"})
    public static void assertData(String forWhat, long expectedValue) throws IOException {
        long[][] values;
        TSDBWriter dbWriter = ((TSDBMeasurementStore)RecorderFactory.MEASUREMENT_STORE).getDBWriter();
        dbWriter.flush();
        File file = dbWriter.getFile();
        List tableDefs = TSDBQuery.getTableDef((File)file, (String)forWhat);
        TableDef tableDef = (TableDef)tableDefs.get(0);
        TimeSeries timeSeries = TSDBQuery.getTimeSeries((File)file, (long[])new long[]{tableDef.id}, (long)0L, (long)Long.MAX_VALUE);
        long sum = 0L;
        for (long[] row : values = timeSeries.getValues()) {
            sum += row[0];
        }
        Assert.assertEquals((long)expectedValue, (long)sum);
    }

    public static void main(String[] args) throws IOException, InterruptedException {
        new RecorderFactoryTest().testCreateScalableQuantizedRecorder();
    }
}

