/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.recyclable.impl;

import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.recyclable.impl.ExpensiveTestObject;

public final class ExpensiveTestObjectFactory
implements RecyclingSupplier.Factory<ExpensiveTestObject> {
    private static final Logger LOG = LoggerFactory.getLogger(ExpensiveTestObjectFactory.class);
    private final long maxIdleMillis;
    private final int nrUsesToFailAfter;
    private final long minOperationMillis;
    private final long maxOperationMillis;

    public ExpensiveTestObjectFactory(long maxIdleMillis, int nrUsesToFailAfter, long minOperationMillis, long maxOperationMillis) {
        this.maxIdleMillis = maxIdleMillis;
        this.nrUsesToFailAfter = nrUsesToFailAfter;
        this.minOperationMillis = minOperationMillis;
        this.maxOperationMillis = maxOperationMillis;
    }

    public ExpensiveTestObjectFactory() {
        this(100L, 10, 1L, 20L);
    }

    public ExpensiveTestObject create() {
        return new ExpensiveTestObject(this.maxIdleMillis, this.nrUsesToFailAfter, this.minOperationMillis, this.maxOperationMillis);
    }

    public void dispose(ExpensiveTestObject object) {
        try {
            object.close();
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (IOException ex) {
            LOG.warn("Cannot dispose object {}", (Object)this, (Object)ex);
        }
    }

    public boolean validate(ExpensiveTestObject object, Exception e) throws IOException {
        if (e instanceof IOException) {
            return false;
        }
        object.testObject();
        return true;
    }

    public String toString() {
        return "ExpensiveTestObjectFactory{maxIdleMillis=" + this.maxIdleMillis + ", nrUsesToFailAfter=" + this.nrUsesToFailAfter + ", minOperationMillis=" + this.minOperationMillis + ", maxOperationMillis=" + this.maxOperationMillis + '}';
    }
}

