/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.ssdump2.Converter;
import org.spf4j.stackmonitor.SampleNode;
import org.spf4j.stackmonitor.Sampler;
import org.spf4j.stackmonitor.SimpleStackCollector;

@NotThreadSafe
public final class DemoTest {
    private static final Logger LOG = LoggerFactory.getLogger(DemoTest.class);
    private static volatile boolean stopped;

    @Test
    public void testJmx() throws InterruptedException, IOException {
        Sampler sampler = new Sampler(t -> new SimpleStackCollector(t));
        sampler.registerJmx();
        sampler.start();
        DemoTest.main(new String[0]);
        sampler.stop();
        SampleNode original = (SampleNode)sampler.getStackCollections().values().iterator().next();
        File file = sampler.dumpToFile();
        LOG.debug("Samples saved to {}", (Object)file);
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.exists());
        SampleNode loaded = Converter.load((File)file);
        Assert.assertEquals((Object)original, (Object)loaded);
        sampler.stop();
    }

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
    public static void main(String[] args) throws InterruptedException {
        List<Thread> threads = DemoTest.startTestThreads(20);
        Thread.sleep(5000L);
        DemoTest.stopTestThreads(threads);
    }

    public static void stopTestThreads(List<Thread> threads) throws InterruptedException {
        stopped = true;
        for (Thread t : threads) {
            t.join(3000L);
        }
    }

    public static List<Thread> startTestThreads(int nrThreads) {
        stopped = false;
        ArrayList<Thread> threads = new ArrayList<Thread>(nrThreads);
        for (int i = 0; i < nrThreads; ++i) {
            Thread t = new Thread(new Runnable(){

                @Override
                @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
                public void run() {
                    try {
                        double d = 0.0;
                        while (!stopped) {
                            d += this.doStuff();
                            Thread.sleep(1L);
                        }
                        LOG.debug("nr = {}", (Object)d);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }

                private double doStuff() {
                    return this.getStuff(10.0) * this.getStuff(10.0) * this.getStuff(10.0) * this.getStuff(10.0);
                }

                private double getStuff(double nr) {
                    return Math.exp(nr);
                }
            }, "Thread" + i);
            t.start();
            threads.add(t);
        }
        return threads;
    }
}

