/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.stackmonitor;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Methods;
import org.spf4j.base.Objects;
import org.spf4j.base.Pair;
import org.spf4j.base.avro.Method;
import org.spf4j.stackmonitor.SampleNode;

@SuppressFBWarnings(value={"LO_INCORRECT_NUMBER_OF_ANCHOR_PARAMETERS"})
public final class SampleNodeTest {
    private static final Logger LOG = LoggerFactory.getLogger(SampleNodeTest.class);

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testSampleNode() throws IOException {
        LOG.debug("sample");
        StackTraceElement[] st1 = new StackTraceElement[]{new StackTraceElement("C1", "m1", "C1.java", 10), new StackTraceElement("C1", "m2", "C1.java", 11), new StackTraceElement("C1", "m3", "C1.java", 12)};
        SampleNode node1 = SampleNode.createSampleNode((StackTraceElement[])st1);
        SampleNode node2 = new SampleNode(st1, st1.length - 1);
        LOG.debug("Node 1", (Object)node1);
        LOG.debug("Node 2", (Object)node2);
        Assert.assertEquals((long)4L, (long)node1.getNrNodes());
        Assert.assertEquals((long)4L, (long)node2.getNrNodes());
        StackTraceElement[] st2 = new StackTraceElement[]{new StackTraceElement("C1", "m1", "C1.java", 10)};
        SampleNode.addToSampleNode((SampleNode)node1, (StackTraceElement[])st2);
        node2.addSample(st2, st2.length - 1);
        LOG.debug("Node 1", (Object)node1);
        LOG.debug("Node 2", (Object)node2);
        Assert.assertEquals((long)5L, (long)node1.getNrNodes());
        Assert.assertEquals((long)5L, (long)node2.getNrNodes());
        StackTraceElement[] st3 = new StackTraceElement[]{new StackTraceElement("C2", "m1", "C2.java", 10), new StackTraceElement("C2", "m2", "C2.java", 11), new StackTraceElement("C2", "m3", "C2.java", 12)};
        SampleNode.addToSampleNode((SampleNode)node1, (StackTraceElement[])st3);
        node2.addSample(st3, st3.length - 1);
        LOG.debug("Node 1", (Object)node1);
        LOG.debug("Node 2", (Object)node2);
        StackTraceElement[] st4 = new StackTraceElement[]{new StackTraceElement("C1", "m1", "C1.java", 10), new StackTraceElement("C1", "m2", "C1.java", 11), new StackTraceElement("C1", "m4", "C1.java", 14)};
        SampleNode.addToSampleNode((SampleNode)node1, (StackTraceElement[])st4);
        node2.addSample(st4, st4.length - 1);
        SampleNode.addToSampleNode((SampleNode)node1, (StackTraceElement[])st1);
        node2.addSample(st1, st1.length - 1);
        LOG.debug("Node 1", (Object)node1);
        LOG.debug("Node 2", (Object)node2);
        Assert.assertEquals((Object)node1.toString(), (Object)node2.toString());
        SampleNode agg = SampleNode.aggregate((SampleNode)node1, (SampleNode)node2);
        LOG.debug("n1 + n2", (Object)agg);
        Assert.assertEquals((long)(node1.getSampleCount() + node2.getSampleCount()), (long)agg.getSampleCount());
        Method method = Methods.getMethod((String)"C1", (String)"m3");
        Assert.assertEquals((long)(((SampleNode)node1.getSubNodes().get((Object)method)).getSampleCount() + ((SampleNode)node2.getSubNodes().get((Object)method)).getSampleCount()), (long)((SampleNode)agg.getSubNodes().get((Object)method)).getSampleCount());
        StringBuilder sb = new StringBuilder();
        node1.writeTo(sb);
        LOG.debug("Serialized String", (Object)sb);
        Pair parsed = SampleNode.parse((Reader)new StringReader(sb.toString()));
        Assert.assertEquals((Object)node1, (Object)parsed.getSecond());
        Assert.assertEquals((Object)node1, (Object)Objects.clone((Serializable)node1));
        SampleNode.traverse((Method)((Method)parsed.getFirst()), (SampleNode)((SampleNode)parsed.getSecond()), (f, t, s) -> {
            LOG.debug("{} -> {} sampled {} times", new Object[]{f, t, s});
            return true;
        });
    }
}

