/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.tsdb2;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.specific.SpecificDatumReader;
import org.apache.avro.specific.SpecificDatumWriter;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.io.ByteArrayBuilder;
import org.spf4j.tsdb2.avro.DataBlock;

public class AvroTest {
    @Test
    public void testRw() throws IOException {
        DataBlock data = DataBlock.newBuilder().setBaseTimestamp(0L).setValues(Collections.EMPTY_LIST).build();
        try (ByteArrayBuilder bab = new ByteArrayBuilder();){
            Schema schema = data.getSchema();
            SpecificDatumWriter writer = new SpecificDatumWriter(schema);
            BinaryEncoder directBinaryEncoder = EncoderFactory.get().directBinaryEncoder((OutputStream)bab, null);
            writer.write((Object)data, (Encoder)directBinaryEncoder);
            directBinaryEncoder.flush();
            ByteArrayInputStream bis = new ByteArrayInputStream(bab.getBuffer(), 0, bab.size());
            SpecificDatumReader reader = new SpecificDatumReader(schema);
            BinaryDecoder directBinaryDecoder = DecoderFactory.get().directBinaryDecoder((InputStream)bis, null);
            DataBlock read = (DataBlock)reader.read(null, (Decoder)directBinaryDecoder);
            Assert.assertEquals((Object)read, (Object)data);
        }
    }
}

