/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Instant;
import java.util.concurrent.ScheduledFuture;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.concurrent.DefaultScheduler;

@SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
public final class DefaultSchedulerTest {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchedulerTest.class);
    private volatile boolean notAligned = false;

    @Test
    public void testScheduleAllignedAtFixedRateMillis() throws InterruptedException {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                long time = System.currentTimeMillis();
                if (time % 1000L >= 100L) {
                    DefaultSchedulerTest.this.notAligned = true;
                }
                LOG.debug("scheduled at {}", (Object)Instant.ofEpochMilli(time));
            }
        };
        long millisInterval = 1000L;
        ScheduledFuture result = DefaultScheduler.scheduleAllignedAtFixedRateMillis((Runnable)command, (long)millisInterval);
        Thread.sleep(10000L);
        result.cancel(true);
        if (this.notAligned) {
            Assert.fail((String)"Scheduled tasks not alligned");
        }
    }
}

