/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.base;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.ExecutionContext;
import org.spf4j.base.ExecutionContexts;
import org.spf4j.concurrent.ContextPropagatingCompletableFuture;
import org.spf4j.concurrent.DefaultExecutor;
import org.spf4j.log.Level;
import org.spf4j.log.Slf4jLogRecord;
import org.spf4j.log.Slf4jLogRecordImpl;

@SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
public class ExecutionContextTest {
    private static final Logger LOG = LoggerFactory.getLogger(ExecutionContextTest.class);
    private static final ExecutionContext.Tag<String, Void> KEY_TAG = new ExecutionContext.Tag<String, Void>(){

        public String toString() {
            return "KEY";
        }
    };

    @Test
    public void testExecutionContext() throws InterruptedException, ExecutionException, TimeoutException {
        ExecutionContext orig = ExecutionContexts.current();
        try (ExecutionContext ec = ExecutionContexts.start((long)10L, (TimeUnit)TimeUnit.SECONDS);){
            long unitsToDeadline = ExecutionContexts.current().getTimeToDeadline(TimeUnit.SECONDS);
            Assert.assertThat((Object)unitsToDeadline, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(10L)));
            Assert.assertThat((Object)unitsToDeadline, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(9L)));
            Future<?> submit = DefaultExecutor.INSTANCE.submit(() -> {
                try (ExecutionContext subCtx = ExecutionContexts.start((ExecutionContext)ec);){
                    long utd = ExecutionContexts.current().getUncheckedTimeToDeadline(TimeUnit.SECONDS);
                    Assert.assertThat((Object)utd, (Matcher)Matchers.lessThanOrEqualTo((Comparable)Long.valueOf(10L)));
                    Assert.assertThat((Object)utd, (Matcher)Matchers.greaterThanOrEqualTo((Comparable)Long.valueOf(9L)));
                    Assert.assertEquals((Object)ec, (Object)subCtx.getSource());
                }
                Assert.assertNull((Object)ExecutionContexts.current());
            });
            submit.get();
        }
        Assert.assertSame((Object)orig, (Object)ExecutionContexts.current());
    }

    @Test
    public void testExecutionContext2() throws TimeoutException {
        try (ExecutionContext start = ExecutionContexts.start((long)10L, (TimeUnit)TimeUnit.SECONDS);){
            long secs = start.getTimeToDeadline(TimeUnit.SECONDS);
            Assert.assertTrue((secs >= 9L ? 1 : 0) != 0);
            Assert.assertTrue((secs <= 10L ? 1 : 0) != 0);
            start.put(KEY_TAG, (Object)"BAGAGE");
            Assert.assertEquals((Object)"BAGAGE", (Object)start.get(KEY_TAG));
        }
    }

    @Test
    public void testExecutionContext3() throws TimeoutException {
        try (ExecutionContext start = ExecutionContexts.start((long)10L, (TimeUnit)TimeUnit.SECONDS);){
            long secs = start.getSecondsToDeadline();
            Assert.assertTrue((String)("secs = " + secs), (secs >= 9L ? 1 : 0) != 0);
            Assert.assertTrue((String)("secs = " + secs), (secs <= 10L ? 1 : 0) != 0);
            start.put(KEY_TAG, (Object)"BAGAGE");
            Assert.assertEquals((Object)"BAGAGE", (Object)start.get(KEY_TAG));
        }
    }

    @Test
    public void testExecutionPropagetionOfLogs() throws TimeoutException, InterruptedException, ExecutionException {
        try (ExecutionContext start = ExecutionContexts.start((long)10L, (TimeUnit)TimeUnit.SECONDS);){
            Slf4jLogRecordImpl log = new Slf4jLogRecordImpl("bla", Level.DEBUG, "{}", new Object[]{"bla"});
            try (ExecutionContext second = start.startChild("ss", 10L, TimeUnit.SECONDS);){
                second.addLog((Slf4jLogRecord)log);
            }
            ArrayList logs = new ArrayList(2);
            start.streamLogs(logs::add);
            Assert.assertEquals((Object)log, logs.get(0));
        }
        start = ExecutionContexts.start((long)10L, (TimeUnit)TimeUnit.SECONDS);
        var2_2 = null;
        try {
            ExecutionContext.Tag<String, Void> tag = new ExecutionContext.Tag<String, Void>(){

                public String toString() {
                    return "mine";
                }
            };
            start.combine((ExecutionContext.Tag)tag, (Object)"bla");
            Assert.assertEquals((Object)"bla", (Object)start.get((ExecutionContext.Tag)tag));
            start.combine((ExecutionContext.Tag)tag, (Object)"bla2");
            Assert.assertEquals((Object)"bla2", (Object)start.get((ExecutionContext.Tag)tag));
            Slf4jLogRecordImpl log = new Slf4jLogRecordImpl("bla", Level.DEBUG, "{}", new Object[]{"bla"});
            Slf4jLogRecordImpl log2 = new Slf4jLogRecordImpl("bla2", Level.DEBUG, "{}", new Object[]{"bla2"});
            CompletionStage fut = ContextPropagatingCompletableFuture.supplyAsync(() -> {
                ExecutionContexts.current().addLog((Slf4jLogRecord)log);
                return "";
            }, (Executor)DefaultExecutor.INSTANCE).whenComplete((a, t) -> ExecutionContexts.current().addLog((Slf4jLogRecord)log2));
            ((CompletableFuture)fut).get();
            ArrayList logs = new ArrayList(2);
            start.streamLogs(logs::add);
            LOG.debug("Context logs", logs);
            Assert.assertEquals((Object)log, logs.get(0));
            Assert.assertEquals((Object)log2, logs.get(1));
        }
        catch (Throwable throwable) {
            var2_2 = throwable;
            throw throwable;
        }
        finally {
            if (start != null) {
                if (var2_2 != null) {
                    try {
                        start.close();
                    }
                    catch (Throwable throwable) {
                        var2_2.addSuppressed(throwable);
                    }
                } else {
                    start.close();
                }
            }
        }
    }

    @Test
    public void testContextInheritance() {
        try (ExecutionContext start = ExecutionContexts.start((String)"test", (long)10L, (TimeUnit)TimeUnit.SECONDS);){
            start.put(KEY_TAG, (Object)"bla");
            ExecutionContext detachedChild = start.detachedChild("detached");
            try (ExecutionContext start2 = ExecutionContexts.start((String)"test", (ExecutionContext)detachedChild, (long)10L, (TimeUnit)TimeUnit.SECONDS);){
                Assert.assertEquals((Object)"bla", (Object)start2.get(KEY_TAG));
            }
        }
    }
}

