/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.spf4j.concurrent.LifoThreadPoolExecutor2Test;
import org.spf4j.concurrent.LifoThreadPoolExecutorSQP;
import org.spf4j.concurrent.MutableLifoThreadPool;

public class MutableThreadPoolExecutor2Test {
    @Test
    public void testLifoExecSQ() throws InterruptedException, IOException, ExecutionException {
        LifoThreadPoolExecutorSQP executor = new LifoThreadPoolExecutorSQP("test", 2, 8, 60000, 1024);
        MutableThreadPoolExecutor2Test.assertTestPoolThreadDynamics((MutableLifoThreadPool)executor);
    }

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
    public static void assertTestPoolThreadDynamics(MutableLifoThreadPool le) throws InterruptedException {
        le.setMaxIdleTimeMillis(1000);
        LifoThreadPoolExecutor2Test.testMaxParallel((ExecutorService)le, 10, 3L, TimeUnit.SECONDS);
        Assert.assertEquals((long)8L, (long)le.getThreadCount());
        le.setMaxThreadCount(4);
        Thread.sleep(1000L);
        Assert.assertEquals((long)2L, (long)le.getThreadCount());
        le.setMaxIdleTimeMillis(1000);
        LifoThreadPoolExecutor2Test.testMaxParallel((ExecutorService)le, 8, 3L, TimeUnit.SECONDS);
        Assert.assertEquals((long)4L, (long)le.getThreadCount());
        le.shutdown();
        boolean awaitTermination = le.awaitTermination(10000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)awaitTermination);
    }
}

