/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent.jdbc;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.concurrent.jdbc.JdbcSemaphore;
import org.spf4j.stackmonitor.Sampler;

@SuppressFBWarnings(value={"PREDICTABLE_RANDOM", "HARD_CODE_PASSWORD"})
public final class DecentSemaphoreHandler {
    private static final Logger LOG = LoggerFactory.getLogger(DecentSemaphoreHandler.class);

    private DecentSemaphoreHandler() {
    }

    @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
    public static void main(String[] args) throws InterruptedException, TimeoutException, SQLException, IOException {
        String connectionString = args[0];
        String semaphoreName = args[1];
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL(connectionString);
        ds.setUser("sa");
        ds.setPassword("sa");
        Sampler s = new Sampler(5, 10000);
        s.registerJmx();
        s.start();
        LOG.info("started sampling");
        JdbcSemaphore semaphore = new JdbcSemaphore((DataSource)ds, semaphoreName, 3);
        for (int i = 0; i < 50; ++i) {
            semaphore.acquire(1, 1L, TimeUnit.SECONDS);
            Thread.sleep((long)(Math.random() * 10.0) + 10L);
            LOG.info("beat");
            Thread.sleep((long)(Math.random() * 10.0) + 10L);
            semaphore.release();
        }
        semaphore.close();
        File dumpToFile = s.dumpToFile();
        LOG.info("stack samples dumped to {}", (Object)dumpToFile);
        s.stop();
        System.exit(0);
    }

    static {
        System.setProperty("spf4j.heartbeat.intervalMillis", "2000");
    }
}

