/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.concurrent.jdbc;

import com.google.common.io.Resources;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Instant;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.h2.tools.Server;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.Runtime;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.jdbc.BadSemaphoreHandler;
import org.spf4j.concurrent.jdbc.DecentSemaphoreHandler;
import org.spf4j.concurrent.jdbc.HeartBeatTableDesc;
import org.spf4j.concurrent.jdbc.JdbcHeartBeat;
import org.spf4j.concurrent.jdbc.JdbcLock;
import org.spf4j.concurrent.jdbc.JdbcSemaphore;
import org.spf4j.concurrent.jdbc.SemaphoreTablesDesc;
import org.spf4j.pool.jdbc.PooledDataSource;
import org.spf4j.recyclable.ObjectCreationException;
import org.spf4j.recyclable.ObjectDisposeException;
import org.spf4j.recyclable.RecyclingSupplier;
import org.spf4j.stackmonitor.Sampler;

@SuppressFBWarnings(value={"HARD_CODE_PASSWORD", "SQL_INJECTION_JDBC"})
public class JdbcSemaphoreTest {
    private static final Logger LOG = LoggerFactory.getLogger(JdbcSemaphoreTest.class);
    private static String hbddl;
    private static String semddl;

    static void createSchemaObjects(DataSource ds) throws SQLException {
        try (Connection conn = ds.getConnection();){
            try (Statement stmt = conn.createStatement();){
                stmt.execute(hbddl);
            }
            stmt = conn.createStatement();
            var4_6 = null;
            try {
                stmt.execute(semddl);
            }
            catch (Throwable throwable) {
                var4_6 = throwable;
                throw throwable;
            }
            finally {
                if (stmt != null) {
                    if (var4_6 != null) {
                        try {
                            stmt.close();
                        }
                        catch (Throwable throwable) {
                            var4_6.addSuppressed(throwable);
                        }
                    } else {
                        stmt.close();
                    }
                }
            }
        }
    }

    static PooledDataSource createPooledDS(final JdbcDataSource ds) throws ObjectCreationException {
        return new PooledDataSource(0, 4, (RecyclingSupplier.Factory)new RecyclingSupplier.Factory<Connection>(){

            public Connection create() throws ObjectCreationException {
                try {
                    return ds.getConnection();
                }
                catch (SQLException ex) {
                    throw new ObjectCreationException((Throwable)ex);
                }
            }

            public void dispose(Connection object) throws ObjectDisposeException {
                try {
                    object.close();
                }
                catch (SQLException ex) {
                    throw new ObjectDisposeException((Throwable)ex);
                }
            }

            public boolean validate(Connection object, Exception e) throws SQLException {
                return object.isValid(60);
            }
        });
    }

    @Test
    public void testSingleProcess() throws SQLException, IOException, InterruptedException, TimeoutException, ObjectCreationException, ObjectDisposeException {
        JdbcDataSource hds = new JdbcDataSource();
        hds.setURL("jdbc:h2:mem:test");
        hds.setUser("sa");
        hds.setPassword("sa");
        PooledDataSource ds = JdbcSemaphoreTest.createPooledDS(hds);
        try (Connection conn = ds.getConnection();){
            JdbcSemaphoreTest.createSchemaObjects((DataSource)ds);
            JdbcHeartBeat heartbeat = JdbcHeartBeat.getHeartBeatAndSubscribe((DataSource)ds, (HeartBeatTableDesc)HeartBeatTableDesc.DEFAULT, (JdbcHeartBeat.LifecycleHook)null);
            long lb = heartbeat.getLastRunDB();
            LOG.debug("last TS = {}", (Object)Instant.ofEpochMilli(lb));
            heartbeat.beat();
            JdbcSemaphoreTest.testReleaseAck((DataSource)ds, "testSem", 2);
            JdbcSemaphoreTest.testReleaseAck((DataSource)ds, "testSem2", 2);
            heartbeat.close();
        }
        ds.close();
    }

    @Test
    public void testSingleProcessLock() throws SQLException, IOException, InterruptedException, TimeoutException {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:test");
        ds.setUser("sa");
        ds.setPassword("sa");
        try (Connection conn = ds.getConnection();){
            JdbcSemaphoreTest.createSchemaObjects((DataSource)ds);
            JdbcLock lock = new JdbcLock((DataSource)ds, SemaphoreTablesDesc.DEFAULT, "testLock", 10);
            lock.lock();
            Assert.assertFalse((boolean)lock.tryLock());
            lock.unlock();
        }
    }

    @Test(expected=SQLException.class)
    public void testSingleMultipleInstance() throws SQLException, IOException, InterruptedException, TimeoutException {
        JdbcDataSource ds = new JdbcDataSource();
        ds.setURL("jdbc:h2:mem:test");
        ds.setUser("sa");
        ds.setPassword("sa");
        try (Connection conn = ds.getConnection();){
            JdbcSemaphoreTest.createSchemaObjects((DataSource)ds);
            JdbcLock lock = new JdbcLock((DataSource)ds, SemaphoreTablesDesc.DEFAULT, "testLock", 10);
            JdbcLock lock2 = new JdbcLock((DataSource)ds, SemaphoreTablesDesc.DEFAULT, "testLock", 10);
            lock.lock();
            Assert.assertFalse((boolean)lock.tryLock());
            lock.unlock();
            lock2.lock();
            lock.unlock();
        }
    }

    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public static void testReleaseAck(DataSource ds, String semName, int maxReservations) throws SQLException, InterruptedException, TimeoutException {
        JdbcSemaphore semaphore = new JdbcSemaphore(ds, semName, maxReservations);
        int totalPermits = semaphore.totalPermits();
        int acquire = totalPermits - 1;
        semaphore.acquire(acquire, 1L, TimeUnit.SECONDS);
        Assert.assertEquals((long)1L, (long)semaphore.permitsOwned());
        int nrPermits = semaphore.totalPermits();
        semaphore.updatePermits(nrPermits + 1);
        Assert.assertEquals((long)(nrPermits + 1), (long)semaphore.totalPermits());
        semaphore.updatePermits(nrPermits);
        Assert.assertEquals((long)nrPermits, (long)semaphore.totalPermits());
        semaphore.reducePermits(2);
        Assert.assertFalse((boolean)semaphore.tryAcquire(2L, TimeUnit.SECONDS));
        semaphore.release(acquire);
        semaphore.increasePermits(2);
        Assert.assertEquals((long)totalPermits, (long)semaphore.totalPermits());
        Assert.assertTrue((boolean)semaphore.tryAcquire(1, 10L, TimeUnit.SECONDS));
        semaphore.release(1);
        Assert.assertTrue((boolean)semaphore.tryAcquire(2, 10L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)semaphore.tryAcquire(1, 2L, TimeUnit.SECONDS));
        semaphore.release(1);
        semaphore.release(1);
        Assert.assertEquals((long)maxReservations, (long)semaphore.availablePermits());
        Assert.assertEquals((long)maxReservations, (long)semaphore.totalPermits());
        semaphore.reducePermits(1);
        Assert.assertEquals((long)(maxReservations - 1), (long)semaphore.totalPermits());
        Assert.assertEquals((long)(maxReservations - 1), (long)semaphore.availablePermits());
        Assert.assertTrue((boolean)semaphore.tryAcquire(1, 10L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)semaphore.tryAcquire(1, 2L, TimeUnit.SECONDS));
        semaphore.release(1);
        try {
            semaphore.release(1);
            Assert.fail((String)"should not be allow to release!");
        }
        catch (IllegalStateException ex) {
            Assert.assertTrue((boolean)ex.getMessage().contains("Trying to release more than you own"));
        }
        semaphore.increasePermits(1);
        Assert.assertTrue((boolean)semaphore.tryAcquire(2, 10L, TimeUnit.SECONDS));
        semaphore.reducePermits(1);
        semaphore.release(2);
        Assert.assertFalse((boolean)semaphore.tryAcquire(2, 10L, TimeUnit.SECONDS));
        semaphore.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @SuppressFBWarnings(value={"AFBR_ABNORMAL_FINALLY_BLOCK_RETURN"})
    public void testMultiProcess() throws SQLException, IOException, InterruptedException, ExecutionException, TimeoutException {
        Server server = Server.createTcpServer((String[])new String[]{"-tcpPort", "9123", "-tcpAllowOthers"}).start();
        File tempDB = File.createTempFile("test", "h2db");
        String connStr = "jdbc:h2:tcp://localhost:9123/nio:" + tempDB.getAbsolutePath() + ";AUTO_SERVER=TRUE";
        try {
            JdbcDataSource ds = new JdbcDataSource();
            ds.setURL(connStr);
            ds.setUser("sa");
            ds.setPassword("sa");
            JdbcSemaphoreTest.createSchemaObjects((DataSource)ds);
            JdbcSemaphoreTest.testReleaseAck((DataSource)ds, "testSem", 2);
            JdbcSemaphore semaphore = new JdbcSemaphore((DataSource)ds, "test_sem2", 3);
            Runtime.jrun(BadSemaphoreHandler.class, (long)10000L, (String[])new String[]{connStr, "test_sem2"});
            Runtime.jrun(BadSemaphoreHandler.class, (long)10000L, (String[])new String[]{connStr, "test_sem2"});
            Assert.assertTrue((boolean)semaphore.tryAcquire(1L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)semaphore.tryAcquire(10L, TimeUnit.SECONDS));
            JdbcHeartBeat.stopHeartBeats();
            server.stop();
        }
        finally {
            if (!tempDB.delete()) {
                throw new IOException("Cannot delete " + tempDB);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultiProcess2() throws SQLException, IOException, InterruptedException, ExecutionException, TimeoutException {
        Server server = Server.createTcpServer((String[])new String[]{"-tcpPort", "9123", "-tcpAllowOthers"}).start();
        try {
            File tempDB = File.createTempFile("test", "h2db");
            tempDB.deleteOnExit();
            String connStr = "jdbc:h2:tcp://localhost:9123/nio:" + tempDB.getAbsolutePath() + ";AUTO_SERVER=TRUE";
            JdbcDataSource ds = new JdbcDataSource();
            ds.setURL(connStr);
            ds.setUser("sa");
            ds.setPassword("sa");
            JdbcSemaphoreTest.createSchemaObjects((DataSource)ds);
            JdbcSemaphore semaphore = new JdbcSemaphore((DataSource)ds, "test_sem2", 1, true);
            String o1 = Runtime.jrun(DecentSemaphoreHandler.class, (long)10000000L, (String[])new String[]{connStr, "test_sem2"}).toString();
            String o2 = Runtime.jrun(DecentSemaphoreHandler.class, (long)10000000L, (String[])new String[]{connStr, "test_sem2"}).toString();
            Assert.assertTrue((boolean)semaphore.tryAcquire(1L, TimeUnit.SECONDS));
            Assert.assertFalse((boolean)semaphore.tryAcquire(10L, TimeUnit.SECONDS));
            LOG.debug("P1: {}", (Object)o1);
            LOG.debug("P2: {}", (Object)o2);
            String[] nr1 = o1.split("\n");
            String[] nr2 = o2.split("\n");
            int totatl = nr1.length + nr2.length;
            HashSet<String> numbers = new HashSet<String>(totatl);
            numbers.addAll(Arrays.asList(nr1));
            numbers.addAll(Arrays.asList(nr2));
            Assert.assertEquals((long)totatl, (long)numbers.size());
        }
        finally {
            JdbcHeartBeat.stopHeartBeats();
            server.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testPerformance() throws SQLException, IOException, InterruptedException, ExecutionException, TimeoutException {
        Server server = Server.createTcpServer((String[])new String[]{"-tcpPort", "9123", "-tcpAllowOthers"}).start();
        try {
            File tempDB = File.createTempFile("test", "h2db");
            tempDB.deleteOnExit();
            String connStr = "jdbc:h2:tcp://localhost:9123/nio:" + tempDB.getAbsolutePath() + ";AUTO_SERVER=TRUE";
            JdbcDataSource ds = new JdbcDataSource();
            ds.setURL(connStr);
            ds.setUser("sa");
            ds.setPassword("sa");
            JdbcSemaphoreTest.createSchemaObjects((DataSource)ds);
            JdbcSemaphore semaphore = new JdbcSemaphore((DataSource)ds, "test_sem2", 1, true);
            Sampler s = new Sampler(5, 5000);
            s.registerJmx();
            s.start();
            LOG.info("started sampling");
            long deadline = TimeSource.nanoTime() + TimeUnit.SECONDS.toNanos(10L);
            do {
                semaphore.acquire(1, 1L, TimeUnit.SECONDS);
                semaphore.release();
            } while (deadline > TimeSource.nanoTime());
            semaphore.close();
            s.stop();
            LOG.debug("dumped samples to {}", (Object)s.dumpToFile());
        }
        finally {
            JdbcHeartBeat.stopHeartBeats();
            server.stop();
        }
    }

    static {
        try {
            hbddl = Resources.toString((URL)Resources.getResource((String)"heartBeats.sql"), (Charset)StandardCharsets.US_ASCII);
            semddl = Resources.toString((URL)Resources.getResource((String)"semaphoreTable.sql"), (Charset)StandardCharsets.US_ASCII);
        }
        catch (IOException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

