/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.PermitSupplier;
import org.spf4j.failsafe.LimitingExecutor;
import org.spf4j.failsafe.RateLimiter;
import org.spf4j.log.Level;
import org.spf4j.test.log.LogAssert;
import org.spf4j.test.log.TestLoggers;
import org.spf4j.test.matchers.LogMatchers;

public class LimitingExecutorTest {
    private static final Logger LOG = LoggerFactory.getLogger(LimitingExecutorTest.class);

    @Test(expected=RejectedExecutionException.class)
    public void testRateLimit() throws Exception {
        try (RateLimiter limiter = new RateLimiter(10L, Duration.ofSeconds(1L), 10L);){
            LimitingExecutor executor = new LimitingExecutor((PermitSupplier)limiter);
            Assert.assertEquals((long)10L, (long)limiter.getPermitsPerReplenishInterval());
            Assert.assertEquals((long)1000000000L, (long)limiter.getPermitReplenishIntervalNanos());
            int i = 0;
            while (i < 10) {
                int val = i++;
                executor.execute(() -> {
                    LOG.debug("executed nr {}", (Object)val);
                    return null;
                });
            }
            Assert.fail();
        }
    }

    @Test
    public void testRateLimit2() throws Exception {
        LogAssert expect = TestLoggers.sys().expect(LimitingExecutorTest.class.getName(), Level.DEBUG, 10, new Matcher[]{LogMatchers.hasFormat((String)"executed nr {}")});
        try (final RateLimiter limiter = new RateLimiter(10L, Duration.ofSeconds(1L), 10L);){
            final long replenishInterval = limiter.getPermitReplenishIntervalNanos();
            LOG.debug("replenish interval = {} ", (Object)replenishInterval);
            LimitingExecutor.RejectedExecutionHandler rejectedExecutionHandler = new LimitingExecutor.RejectedExecutionHandler(){

                @SuppressFBWarnings(value={"MDM_THREAD_YIELD"})
                public Object reject(LimitingExecutor executor, Callable callable) throws Exception {
                    long lastReplenishmentNanos;
                    long nanoTime = TimeSource.nanoTime();
                    long waitNs = replenishInterval - (nanoTime - (lastReplenishmentNanos = limiter.getLastReplenishmentNanos()));
                    if (waitNs >= 0L) {
                        TimeUnit.NANOSECONDS.sleep(waitNs);
                    } else {
                        LOG.debug("negative wait time {}, current = {}, lastUpdated = {}, permits = {} ", new Object[]{waitNs, nanoTime, lastReplenishmentNanos, limiter.getNrPermits()});
                    }
                    return executor.execute(callable);
                }
            };
            LimitingExecutor executor = new LimitingExecutor(rejectedExecutionHandler, limiter.toSemaphore());
            int i = 0;
            while (i < 10) {
                int val = i++;
                executor.execute(() -> {
                    LOG.debug("executed nr {}", (Object)val);
                    return null;
                });
            }
        }
        expect.assertObservation();
    }
}

