/*
 * Decompiled with CFR 0.152.
 */
package org.spf4j.failsafe;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spf4j.base.TestTimeSource;
import org.spf4j.base.TimeSource;
import org.spf4j.concurrent.PermitSupplier;
import org.spf4j.failsafe.RateLimiter;
import org.spf4j.log.Level;
import org.spf4j.test.log.annotations.PrintLogs;

public class RateLimiterTest {
    private static final Logger LOG = LoggerFactory.getLogger(RateLimiterTest.class);

    @Test(expected=IllegalArgumentException.class)
    public void testRateLimitInvalid() {
        new RateLimiter(1000L, Duration.ofSeconds(1L), 9L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRateLimitInvalidTryReservation() throws InterruptedException {
        long nanoTime = TestTimeSource.freezeTime();
        try {
            ScheduledExecutorService mockExec = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
            ScheduledFuture mockFut = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
            Mockito.when(mockExec.scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.anyLong(), Mockito.anyLong(), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))))).thenReturn((Object)mockFut);
            try (RateLimiter rateLimiter = new RateLimiter(10L, Duration.ofNanos(10000000L), 100L, mockExec);){
                long s1Nanos = TimeUnit.SECONDS.toNanos(1L);
                PermitSupplier.Acquisition acq = rateLimiter.tryAcquireGetDelayNanos(1000, nanoTime + s1Nanos);
                Assert.assertEquals((long)s1Nanos, (long)acq.permitAvailableEstimateInNanos());
            }
        }
        finally {
            TestTimeSource.clear();
        }
    }

    @Test
    @PrintLogs(ideMinLevel=Level.TRACE)
    public void testRateLimitArgs() {
        try (RateLimiter rateLimiter = new RateLimiter(17L, Duration.ofSeconds(1L), 20L, 10L, TimeUnit.MILLISECONDS);){
            LOG.debug("Rate Limiter = {}", (Object)rateLimiter);
            Assert.assertEquals((long)17L, (long)rateLimiter.getPermitsPerReplenishInterval());
            Assert.assertEquals((long)1000000000L, (long)rateLimiter.getPermitReplenishIntervalNanos());
        }
    }

    @Test
    public void testRateLimitTryAcquisition() throws InterruptedException {
        try (RateLimiter rateLimiter = new RateLimiter(10L, Duration.ofSeconds(1L), 10L);){
            LOG.debug("Rate Limiter = {}", (Object)rateLimiter);
            Assert.assertFalse((boolean)rateLimiter.tryAcquire(20, 0L, TimeUnit.MILLISECONDS));
            long startTime = TimeSource.nanoTime();
            boolean tryAcquire = rateLimiter.tryAcquire(20, 2L, TimeUnit.SECONDS);
            LOG.debug("waited {} ns for {}", (Object)(TimeSource.nanoTime() - startTime), (Object)rateLimiter);
            Assert.assertTrue((boolean)tryAcquire);
            Assert.assertFalse((boolean)rateLimiter.tryAcquire(20, 1L, TimeUnit.SECONDS));
        }
    }

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testRateLimitTryAcquisition2() throws InterruptedException {
        ScheduledExecutorService mockExec = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ScheduledFuture mockFut = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when(mockExec.scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)100000000L), Mockito.eq((long)100000000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))))).thenReturn((Object)mockFut);
        try (RateLimiter rateLimiter = new RateLimiter(1L, Duration.ofNanos(100000000L), 10L, mockExec, () -> 0L);){
            PermitSupplier.Acquisition acq = rateLimiter.tryAcquireGetDelayNanos(10, TimeUnit.SECONDS.toNanos(10L));
            long tryAcquireGetDelayNs = acq.permitAvailableEstimateInNanos();
            LOG.debug("Rate Limiter = {}, waitMs = {}", (Object)rateLimiter, (Object)tryAcquireGetDelayNs);
            Assert.assertEquals((long)1000000000L, (long)tryAcquireGetDelayNs);
            Assert.assertEquals((double)-10.0, (double)rateLimiter.getNrPermits(), (double)1.0E-4);
            long notEnoughNanos = TimeUnit.MILLISECONDS.toNanos(10L);
            acq = rateLimiter.tryAcquireGetDelayNanos(10, notEnoughNanos);
            Assert.assertFalse((boolean)acq.isSuccess());
            Assert.assertTrue((acq.permitAvailableEstimateInNanos() > notEnoughNanos ? 1 : 0) != 0);
            acq = rateLimiter.tryAcquireGetDelayNanos(1, TimeUnit.MILLISECONDS.toNanos(2000L));
            Assert.assertEquals((long)1100000000L, (long)acq.permitAvailableEstimateInNanos());
        }
        ((ScheduledExecutorService)Mockito.verify((Object)mockExec)).scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)100000000L), Mockito.eq((long)100000000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        ((ScheduledFuture)Mockito.verify((Object)mockFut)).cancel(false);
    }

    @Test
    @SuppressFBWarnings(value={"PRMC_POSSIBLY_REDUNDANT_METHOD_CALLS"})
    public void testRateLimitTryAcquisition3() throws InterruptedException {
        ScheduledExecutorService mockExec = (ScheduledExecutorService)Mockito.mock(ScheduledExecutorService.class);
        ScheduledFuture mockFut = (ScheduledFuture)Mockito.mock(ScheduledFuture.class);
        Mockito.when(mockExec.scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)10000000000L), Mockito.eq((long)10000000000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))))).thenReturn((Object)mockFut);
        try (RateLimiter rateLimiter = new RateLimiter(100L, Duration.ofSeconds(10L), 100L, mockExec, () -> 0L);){
            long tryAcquireGetDelayNs = rateLimiter.tryAcquireGetDelayNanos(2, TimeUnit.SECONDS.toNanos(20L)).permitAvailableEstimateInNanos();
            LOG.debug("Rate Limiter = {}, waitMs = {}", (Object)rateLimiter, (Object)tryAcquireGetDelayNs);
            Assert.assertEquals((long)10000000000L, (long)tryAcquireGetDelayNs);
            Assert.assertEquals((long)-2L, (long)rateLimiter.getNrPermits());
            long notEnoughNanos = TimeUnit.MILLISECONDS.toNanos(10L);
            tryAcquireGetDelayNs = rateLimiter.tryAcquireGetDelayNanos(1, notEnoughNanos).permitAvailableEstimateInNanos();
            Assert.assertTrue((tryAcquireGetDelayNs > notEnoughNanos ? 1 : 0) != 0);
        }
        ((ScheduledExecutorService)Mockito.verify((Object)mockExec)).scheduleAtFixedRate((Runnable)Mockito.any(), Mockito.eq((long)10000000000L), Mockito.eq((long)10000000000L), (TimeUnit)((Object)Mockito.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        ((ScheduledFuture)Mockito.verify((Object)mockFut)).cancel(false);
    }
}

